/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;

public class ChainTestExecutionListener
implements TestExecutionListener {
    private List<TestExecutionListener> afterListeners;
    private List<TestExecutionListener> beforeListeners;

    public ChainTestExecutionListener() {
    }

    public ChainTestExecutionListener(Collection<TestExecutionListener> listeners) {
        this.setTestExecutionListeners(listeners);
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        for (TestExecutionListener listener : this.afterListeners) {
            listener.afterTestClass(testContext);
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        for (TestExecutionListener listener : this.afterListeners) {
            listener.afterTestMethod(testContext);
        }
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        for (TestExecutionListener listener : this.beforeListeners) {
            listener.beforeTestClass(testContext);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        for (TestExecutionListener listener : this.beforeListeners) {
            listener.beforeTestMethod(testContext);
        }
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        for (TestExecutionListener listener : this.beforeListeners) {
            listener.prepareTestInstance(testContext);
        }
    }

    public void setTestExecutionListener(TestExecutionListener listener) {
        this.setTestExecutionListeners(Collections.singleton(listener));
    }

    public void setTestExecutionListeners(Collection<TestExecutionListener> listeners) {
        this.beforeListeners = new ArrayList<TestExecutionListener>(listeners);
        this.afterListeners = new ArrayList<TestExecutionListener>(listeners);
        Collections.reverse(this.afterListeners);
    }
}

