/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.audit;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.ChangedValue;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public final class AuditTestUtils {
    private AuditTestUtils() {
        throw new UnsupportedOperationException("AuditTestUtils is a utility class and should not be instantiated");
    }

    public static Matcher<AuditAttribute> attributeWith(final Matcher<String> nameKeyMatcher, final String value) {
        return new TypeSafeMatcher<AuditAttribute>(){

            protected boolean matchesSafely(AuditAttribute attribute) {
                return nameKeyMatcher.matches((Object)attribute.getNameI18nKey()) && Objects.equals(attribute.getValue(), value);
            }

            public void describeTo(Description description) {
                description.appendText("an AuditAttribute with an i18nNameKey matching ").appendDescriptionOf((SelfDescribing)nameKeyMatcher).appendText(" and value '").appendText(value).appendText("'");
            }
        };
    }

    public static Matcher<ChangedValue> changedValueWith(final Matcher<String> keyMatcher, final String originalValue, final String updatedValue) {
        return new TypeSafeMatcher<ChangedValue>(){

            protected boolean matchesSafely(ChangedValue changedValue) {
                return keyMatcher.matches((Object)changedValue.getI18nKey()) && Objects.equals(changedValue.getFrom(), originalValue) && Objects.equals(changedValue.getTo(), updatedValue);
            }

            public void describeTo(Description description) {
                description.appendText("a ChangedValue with key matching ").appendDescriptionOf((SelfDescribing)keyMatcher).appendText(", original value '").appendText(originalValue).appendText(" and updated value '").appendText(updatedValue).appendText("'");
            }
        };
    }

    public static Matcher<AuditResource> resourceWith(final String type, final String name, final String id) {
        return new TypeSafeMatcher<AuditResource>(){

            public boolean matchesSafely(AuditResource actual) {
                return actual.getType().equals(type) && actual.getName().equals(name) && Objects.equals(actual.getId(), id);
            }

            public void describeTo(Description description) {
                description.appendText("an AuditResource with type '").appendText(type).appendText("',  name '").appendText(name).appendText("' and id '").appendText(id).appendText("'");
            }
        };
    }
}

