/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin;

import com.atlassian.plugin.module.Element;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SimpleElement
implements Element {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, List<Element>> elements = new HashMap<String, List<Element>>();
    private final String name;
    private final String text;

    public SimpleElement(String name) {
        this(name, null);
    }

    public SimpleElement(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public List<String> attributeNames() {
        return List.copyOf(this.attributes.keySet());
    }

    public String attributeValue(String key) {
        return this.attributes.getOrDefault(key, null);
    }

    public String attributeValue(String key, String defaultValue) {
        return this.attributes.getOrDefault(key, defaultValue);
    }

    public Element element(String name) {
        if (!this.elements.containsKey(name) || this.elements.get(name) == null) {
            return null;
        }
        return this.elements.get(name).stream().findFirst().orElse(null);
    }

    public List<Element> elements(String name) {
        if (!this.elements.containsKey(name) || this.elements.get(name) == null) {
            return List.of();
        }
        return this.elements.get(name);
    }

    public List<Element> elements() {
        return this.elements.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String elementTextTrim(String name) {
        if (!this.elements.containsKey(name) || this.elements.get(name) == null) {
            return null;
        }
        return this.elements.get(name).stream().findFirst().map(Element::getTextTrim).orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public String getTextTrim() {
        return StringUtils.trim((String)this.text);
    }

    public SimpleElement withAttribute(String attributeName, String attribute) {
        this.attributes.put(attributeName, attribute);
        return this;
    }

    public SimpleElement withElement(Element element) {
        this.elements.computeIfAbsent(element.getName(), key -> new ArrayList());
        this.elements.get(element.getName()).add(element);
        return this;
    }
}

