/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.context;

import com.atlassian.bitbucket.annotation.DataSet;
import com.atlassian.bitbucket.dbunit.DatabaseConnectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class DataSetTestExecutionListener
extends AbstractTestExecutionListener
implements InitializingBean {
    private final DatabaseConnectionFactory connectionFactory;
    private final Resource dtdResource;
    private final SessionFactory sessionFactory;
    private DataSetBuilder dataSetBuilder;

    public DataSetTestExecutionListener(DatabaseConnectionFactory connectionFactory, SessionFactory sessionFactory) {
        this(connectionFactory, sessionFactory, null);
    }

    public DataSetTestExecutionListener(DatabaseConnectionFactory connectionFactory, SessionFactory sessionFactory, Resource dtdResource) {
        this.connectionFactory = connectionFactory;
        this.dtdResource = dtdResource;
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws DataSetException, IOException {
        if (this.dtdResource == null) {
            this.dataSetBuilder = new NoDtdDataSetBuilder();
        } else {
            try (InputStream inputStream = this.dtdResource.getInputStream();){
                this.dataSetBuilder = new DtdDataSetBuilder((IDataSet)new FlatDtdDataSet(inputStream));
            }
        }
    }

    public void afterTestMethod(@Nonnull TestContext testContext) throws Exception {
        DataSet annotation = this.getDataSetAnnotation(testContext);
        if (annotation != null && annotation.delete()) {
            this.applyAnnotation(testContext, annotation, DatabaseOperation.DELETE, true);
        }
        this.clearCache();
    }

    public void beforeTestMethod(@Nonnull TestContext testContext) throws Exception {
        DataSet annotation = this.getDataSetAnnotation(testContext);
        if (annotation != null && annotation.insert()) {
            this.applyAnnotation(testContext, annotation, DatabaseOperation.INSERT, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAnnotation(TestContext testContext, DataSet annotation, DatabaseOperation operation, boolean commit) throws Exception {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        String[] locations = this.computeLocations(testContext, annotation);
        Resource[] resources = this.resolveResources((ResourceLoader)applicationContext, locations);
        IDataSet dataSet = this.createDataSet(resources);
        try (IDatabaseConnection connection = this.connectionFactory.newConnection();){
            operation.execute(connection, dataSet);
            if (commit && !connection.getConnection().getAutoCommit()) {
                connection.getConnection().commit();
            }
        }
    }

    private void clearCache() {
        this.sessionFactory.getCache().evictEntityRegions();
        this.sessionFactory.getCache().evictCollectionRegions();
    }

    private String[] computeLocations(TestContext testContext, DataSet dataSet) {
        Object[] defaultLocations;
        Object[] locations = dataSet.value();
        if (Arrays.equals(locations, defaultLocations = (String[])AnnotationUtils.getDefaultValue((Annotation)dataSet))) {
            Class testClass = testContext.getTestClass();
            return new String[]{"classpath:dbunit/" + testClass.getSimpleName() + ".xml"};
        }
        return locations;
    }

    private IDataSet createDataSet(Resource[] resources) throws DataSetException, IOException {
        IDataSet[] dataSets = new IDataSet[resources.length];
        for (int i = 0; i < dataSets.length; ++i) {
            dataSets[i] = this.dataSetBuilder.build(resources[i]);
        }
        if (dataSets.length == 1) {
            return dataSets[0];
        }
        return new CompositeDataSet(dataSets);
    }

    private DataSet getDataSetAnnotation(TestContext testContext) {
        Method testMethod = testContext.getTestMethod();
        DataSet dataSet = testMethod.getAnnotation(DataSet.class);
        if (dataSet == null) {
            Class testClass = testContext.getTestClass();
            dataSet = testClass.getAnnotation(DataSet.class);
        }
        return dataSet;
    }

    private Resource[] resolveResources(ResourceLoader resourceLoader, String[] locations) {
        Resource[] resources = new Resource[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            resources[i] = resourceLoader.getResource(locations[i]);
        }
        return resources;
    }

    private static class NoDtdDataSetBuilder
    implements DataSetBuilder {
        private NoDtdDataSetBuilder() {
        }

        @Override
        public IDataSet build(Resource resource) throws DataSetException, IOException {
            return new FlatXmlDataSetBuilder().setColumnSensing(true).setDtdMetadata(false).build(resource.getInputStream());
        }
    }

    private static class DtdDataSetBuilder
    implements DataSetBuilder {
        private final IDataSet dtd;

        private DtdDataSetBuilder(IDataSet dtd) {
            this.dtd = dtd;
        }

        @Override
        public IDataSet build(Resource resource) throws DataSetException, IOException {
            return new FlatXmlDataSetBuilder().setMetaDataSet(this.dtd).build(resource.getInputStream());
        }
    }

    private static interface DataSetBuilder {
        public IDataSet build(Resource var1) throws DataSetException, IOException;
    }
}

