/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.hamcrest.ResponseMatchers;
import com.atlassian.bitbucket.hamcrest.TimeMatchers;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;

public class HttpHeaderAsserts {
    private static final String CACHE_CONTROL_NO_CACHE = "private, no-cache, no-store, no-transform, max-age=0";
    private static final String CACHE_CONTROL_CACHE_PREFIX = "private, max-age=";
    private static final String PRAGMA_NO_CACHE = "no-cache";
    private static final String PRAGMA_CACHE = "";
    private static final long ONE_DAY_IN_SECONDS = TimeUnit.DAYS.toSeconds(1L);
    private static final long FOUR_WEEKS_IN_SECONDS = TimeUnit.DAYS.toSeconds(28L);

    private HttpHeaderAsserts() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static void assertNoCache(HttpServletResponse response) {
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Cache-Control", CACHE_CONTROL_NO_CACHE));
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Pragma", PRAGMA_NO_CACHE));
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Expires", "0"));
    }

    public static void assertCachedFor(HttpServletResponse response, long timeSpan, TimeUnit unit) {
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Cache-Control", CACHE_CONTROL_CACHE_PREFIX + unit.toSeconds(timeSpan)));
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Pragma", PRAGMA_CACHE));
        Date actual = new Date(Long.parseLong(response.getHeader("Expires")));
        Assert.assertThat((Object)actual, TimeMatchers.closeTo(HttpHeaderAsserts.getDateByStartAndSpan(new Date(), timeSpan, unit), 5, TimeUnit.SECONDS));
    }

    public static void assertCachedForOneDay(HttpServletResponse response) {
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Cache-Control", CACHE_CONTROL_CACHE_PREFIX + ONE_DAY_IN_SECONDS));
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Pragma", PRAGMA_CACHE));
        Date actual = new Date(Long.parseLong(response.getHeader("Expires")));
        Assert.assertThat((Object)actual, TimeMatchers.closeTo(HttpHeaderAsserts.getDateByStartAndSpan(new Date(), 1L, TimeUnit.DAYS), 5, TimeUnit.SECONDS));
    }

    public static void assertCachedForFourWeeks(HttpServletResponse response) {
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Cache-Control", CACHE_CONTROL_CACHE_PREFIX + FOUR_WEEKS_IN_SECONDS));
        Assert.assertThat((Object)response, ResponseMatchers.hasHeader("Pragma", PRAGMA_CACHE));
        Assert.assertThat((Object)HttpHeaderAsserts.getDateHeader(response), TimeMatchers.closeTo(HttpHeaderAsserts.getDateByStartAndSpan(new Date(), 28L, TimeUnit.DAYS), 5, TimeUnit.SECONDS));
    }

    private static Date getDateByStartAndSpan(Date start, long timeSpan, TimeUnit unit) {
        long seconds = unit.toSeconds(timeSpan);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(13, (int)seconds);
        return calendar.getTime();
    }

    private static Date getDateHeader(HttpServletResponse response) {
        String expires = response.getHeader("Expires");
        try {
            return new Date(Long.parseLong(expires));
        }
        catch (NumberFormatException e) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                return dateFormat.parse(expires);
            }
            catch (ParseException parseException) {
                throw new AssertionError((Object)("[" + expires + "] is not a valid date header"));
            }
        }
    }
}

