/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.task;

import com.atlassian.bitbucket.hamcrest.SimpleTypeSafeMatcher;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestTaskSearchRequest;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.task.InternalTaskSearchRequest;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class TaskMatchers {
    public static Matcher<PullRequestTaskSearchRequest> hasContext(final PullRequest pullRequest) {
        return new SimpleTypeSafeMatcher<PullRequestTaskSearchRequest>(){

            @Override
            public void describeTo(Description description) {
                description.appendText("PullRequestTaskSearchRequest with context PR=").appendValue((Object)pullRequest);
            }

            protected boolean matchesSafely(PullRequestTaskSearchRequest item) {
                return pullRequest.getId() == item.getPullRequestId() && pullRequest.getToRef().getRepository().getId() == item.getRepositoryId();
            }
        };
    }

    public static Matcher<InternalTaskSearchRequest> hasInternalContext(final InternalPullRequest pullRequest) {
        return new SimpleTypeSafeMatcher<InternalTaskSearchRequest>(){

            @Override
            public void describeTo(Description description) {
                description.appendText("PullRequestTaskSearchRequest with context PR=").appendValue((Object)pullRequest);
            }

            protected boolean matchesSafely(InternalTaskSearchRequest item) {
                return Objects.equals(pullRequest.getId(), item.getPullRequest().getId()) && Objects.equals(pullRequest.getScopeRepository().getId(), item.getPullRequest().getScopeRepository().getId());
            }
        };
    }
}

