/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mockito;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@NotThreadSafe
public class MockCallChainAnswer
implements Answer<Object> {
    private final Answer<?> defaultAnswers = new ReturnsEmptyValues();
    private final LoadingCache<Class<?>, Answer<?>> answerCache;
    private final LoadingCache<Class<?>, Object> mockCache;

    public MockCallChainAnswer() {
        this.answerCache = CacheBuilder.newBuilder().build(new CacheLoader(){

            public Object load(@Nonnull Object key) throws Exception {
                return new MockCallChainAnswer(MockCallChainAnswer.this.answerCache, MockCallChainAnswer.this.mockCache);
            }
        });
        this.mockCache = CacheBuilder.newBuilder().build(new CacheLoader(){

            public Object load(@Nonnull Object clazz) throws Exception {
                return Mockito.mock((Class)((Class)clazz), (Answer)((Answer)MockCallChainAnswer.this.answerCache.getUnchecked((Object)((Class)clazz))));
            }
        });
    }

    private MockCallChainAnswer(LoadingCache<Class<?>, Answer<?>> answerCache, LoadingCache<Class<?>, Object> mockCache) {
        this.answerCache = answerCache;
        this.mockCache = mockCache;
    }

    public Object answer(InvocationOnMock invocation) throws Throwable {
        Class<?> returnType = invocation.getMethod().getReturnType();
        Object defaultAnswer = this.defaultAnswers.answer(invocation);
        if (defaultAnswer != null) {
            return defaultAnswer;
        }
        return this.mockCache.getUnchecked(returnType);
    }

    public <T> T mockFor(Class<T> mockClass) {
        return (T)this.mockCache.getUnchecked(mockClass);
    }
}

