/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.Tag;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class RepositoryMatchers {
    private RepositoryMatchers() {
        throw new UnsupportedOperationException(RepositoryMatchers.class.getName() + " should not be instantiated");
    }

    public static Matcher<Repository> withId(int expectedId) {
        return new FeatureMatcher<Repository, Integer>(Matchers.equalTo((Object)expectedId), "repository ID equal to", "id"){

            protected Integer featureValueOf(@Nonnull Repository actual) {
                return actual.getId();
            }
        };
    }

    public static Matcher<Repository> withName(@Nonnull String expectedName) {
        Objects.requireNonNull(expectedName, "expectedName");
        return RepositoryMatchers.withNameThat((Matcher<String>)Matchers.equalTo((Object)expectedName));
    }

    public static Matcher<Repository> withNameAndId(@Nonnull String expectedName, int expectedId) {
        Objects.requireNonNull(expectedName, "expectedName");
        return Matchers.allOf(RepositoryMatchers.withName(expectedName), RepositoryMatchers.withId(expectedId));
    }

    public static Matcher<Repository> withNameThat(@Nonnull Matcher<String> nameMatcher) {
        Objects.requireNonNull(nameMatcher, "nameMatcher");
        return new FeatureMatcher<Repository, String>(nameMatcher, "repository name that", "name"){

            protected String featureValueOf(@Nonnull Repository actual) {
                return actual.getName();
            }
        };
    }

    public static Matcher<Repository> withProjectName(@Nonnull String expectedProjectName) {
        Objects.requireNonNull(expectedProjectName, "expectedProjectName");
        return new FeatureMatcher<Repository, String>(Matchers.equalTo((Object)expectedProjectName), "project name that", "project name"){

            protected String featureValueOf(@Nonnull Repository actual) {
                return actual.getProject().getName();
            }
        };
    }

    @Factory
    public static Matcher<Branch> branch(String displayId, String latestCommit) {
        return RepositoryMatchers.branch(displayId, latestCommit, false);
    }

    @Factory
    public static Matcher<Branch> branch(String displayId, String latestCommit, boolean isDefault) {
        return new BranchMatcher(displayId, latestCommit, isDefault);
    }

    @Factory
    public static Matcher<Branch> isBranchWithDisplayId(String displayId) {
        return new FeatureMatcher<Branch, String>(Matchers.equalTo((Object)displayId), "display ID", "displayId"){

            protected String featureValueOf(Branch actual) {
                return actual.getDisplayId();
            }
        };
    }

    @Factory
    public static Matcher<Ref> ref(String displayId, String commit) {
        return new RefMatcher(displayId, commit);
    }

    @Factory
    public static Matcher<ResolveRefRequest> resolveBranchRequest(@Nonnull Repository repository, @Nullable String branchId) {
        return RepositoryMatchers.resolveRefRequest(repository, branchId, (RefType)StandardRefType.BRANCH);
    }

    @Factory
    public static Matcher<ResolveRefRequest> resolveRefRequest(@Nonnull Repository repository, @Nullable String refId) {
        return RepositoryMatchers.resolveRefRequest(repository, refId, null);
    }

    @Factory
    public static Matcher<ResolveRefRequest> resolveRefRequest(@Nonnull Repository repository, @Nullable String refId, @Nullable RefType type) {
        return new ResolveRefRequestMatcher(repository, refId, type);
    }

    @Factory
    public static Matcher<ResolveRefRequest> resolveTagRequest(@Nonnull Repository repository, @Nullable String tagId) {
        return RepositoryMatchers.resolveRefRequest(repository, tagId, (RefType)StandardRefType.TAG);
    }

    @Factory
    public static Matcher<Tag> tag(String displayId, String latestCommit) {
        return RepositoryMatchers.tag(displayId, latestCommit, null);
    }

    @Factory
    public static Matcher<Tag> tag(String displayId, String latestCommit, String hash) {
        return new TagMatcher(displayId, latestCommit, hash);
    }

    private static class TagMatcher
    extends TypeSafeMatcher<Tag> {
        private final String displayId;
        private final String latestCommit;
        private final String hash;

        private TagMatcher(String displayId, String latestCommit, String hash) {
            this.displayId = displayId;
            this.latestCommit = latestCommit;
            this.hash = hash;
        }

        public boolean matchesSafely(Tag tag) {
            return StringUtils.equals((CharSequence)tag.getHash(), (CharSequence)this.hash) && tag.getDisplayId().equals(this.displayId) && tag.getLatestCommit().equals(this.latestCommit);
        }

        public void describeTo(Description description) {
            description.appendText("a tag '").appendText(this.displayId).appendText("' with hash ").appendText(this.hash).appendText(" tagging ").appendText(this.latestCommit);
        }
    }

    private static class BranchMatcher
    extends TypeSafeMatcher<Branch> {
        private final String displayId;
        private final String latestCommit;
        private final boolean isDefault;

        private BranchMatcher(String displayId, String latestCommit, boolean isDefault) {
            this.displayId = displayId;
            this.latestCommit = latestCommit;
            this.isDefault = isDefault;
        }

        public boolean matchesSafely(Branch branch) {
            return branch.getDisplayId().equals(this.displayId) && branch.getLatestCommit().equals(this.latestCommit) && branch.getIsDefault() == this.isDefault;
        }

        public void describeTo(Description description) {
            description.appendText("a branch '").appendText(this.displayId).appendText("' at ").appendText(this.latestCommit);
            if (this.isDefault) {
                description.appendText(" (default branch)");
            }
        }
    }

    private static class ResolveRefRequestMatcher
    extends TypeSafeMatcher<ResolveRefRequest> {
        private final String refId;
        private final Repository repository;
        private final RefType type;

        public ResolveRefRequestMatcher(Repository repository, String refId, RefType type) {
            super(ResolveRefRequest.class);
            this.refId = refId;
            this.repository = repository;
            this.type = type;
        }

        public void describeTo(Description description) {
            description.appendText("a request to resolve ");
            if (this.refId == null) {
                description.appendText("the default branch");
            } else {
                description.appendText("a ").appendText(this.type == null ? "REF" : this.type.toString()).appendText(" called ").appendText(this.refId);
            }
            description.appendText(" in ").appendValue((Object)this.repository);
        }

        protected boolean matchesSafely(ResolveRefRequest request) {
            return Objects.equals(this.repository, request.getRepository()) && Objects.equals(this.refId, request.getRefId().orElse(null)) && Objects.equals(this.type, request.getType().orElse(null));
        }
    }

    private static class RefMatcher
    extends TypeSafeMatcher<Ref> {
        private final String displayId;
        private final String latestCommit;

        private RefMatcher(String displayId, String latestCommit) {
            this.displayId = displayId;
            this.latestCommit = latestCommit;
        }

        public boolean matchesSafely(Ref ref) {
            return ref.getDisplayId().equals(this.displayId) && ref.getLatestCommit().equals(this.latestCommit);
        }

        public void describeTo(Description description) {
            description.appendText("a ref '").appendText(this.displayId).appendText("' at ").appendText(this.latestCommit);
        }
    }
}

