/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.util.PageRequest;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class PageRequestMatcher
extends TypeSafeMatcher<PageRequest> {
    private final int limit;
    private final int start;

    public PageRequestMatcher(int limit) {
        this(0, limit);
    }

    public PageRequestMatcher(int start, int limit) {
        this.start = start;
        this.limit = limit;
    }

    @Factory
    public static Matcher<PageRequest> pageRequest(int limit) {
        return new PageRequestMatcher(limit);
    }

    @Factory
    public static Matcher<PageRequest> pageRequest(int start, int limit) {
        return new PageRequestMatcher(start, limit);
    }

    public void describeTo(Description description) {
        description.appendText("A page request with start at ").appendValue((Object)this.start).appendText(" and limit of ").appendValue((Object)this.limit);
    }

    protected boolean matchesSafely(PageRequest parameter) {
        return this.start == parameter.getStart() && this.limit == parameter.getLimit();
    }
}

