/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class TimeMatchers {
    @Factory
    @Nonnull
    public static Matcher<Date> closeTo(final @Nonnull Date expected, final int plusOrMinus, final @Nonnull TimeUnit unit) {
        Objects.requireNonNull(expected, "expected");
        Objects.requireNonNull(unit, "unit");
        return new TypeSafeMatcher<Date>(){

            public boolean matchesSafely(Date date) {
                return Math.abs(expected.getTime() - date.getTime()) < unit.toMillis(plusOrMinus);
            }

            public void describeTo(Description description) {
                description.appendText("a date around ").appendValue((Object)expected).appendText(" plus or minus ").appendValue((Object)plusOrMinus).appendText(" ").appendText(unit.name().toLowerCase());
            }
        };
    }

    @Factory
    @Nonnull
    public static Matcher<Date> closeToNow(int plusOrMinus, @Nonnull TimeUnit unit) {
        return TimeMatchers.closeTo(new Date(), plusOrMinus, unit);
    }
}

