/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.context;

import com.atlassian.bitbucket.annotation.Dao;
import com.atlassian.bitbucket.context.AbstractAnnotationTestExecutionListener;
import java.lang.reflect.Field;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;

public class DaoTestExecutionListener
extends AbstractAnnotationTestExecutionListener<Dao>
implements ApplicationContextAware {
    private static final Class<?> DEFAULT_DAO_CLASS = (Class)AnnotationUtils.getDefaultValue(Dao.class);
    private AutowireCapableBeanFactory beanFactory;

    public DaoTestExecutionListener() {
        super(Dao.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.beanFactory = applicationContext.getAutowireCapableBeanFactory();
    }

    @Override
    protected Object createValue(Field field, Dao annotation) throws IllegalAccessException {
        try {
            return this.beanFactory.getBean(field.getType());
        }
        catch (NoSuchBeanDefinitionException e) {
            return this.beanFactory.createBean(this.getDaoClass(field, annotation), 0, false);
        }
    }

    private Class<?> getDaoClass(Field field, Dao annotation) {
        return DEFAULT_DAO_CLASS.equals(annotation.value()) ? field.getType() : annotation.value();
    }
}

