/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ao;

import com.atlassian.activeobjects.internal.EntityManagedActiveObjects;
import com.atlassian.activeobjects.internal.TransactionManager;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import net.java.ao.ActiveObjectsException;
import net.java.ao.EntityManager;
import net.java.ao.Transaction;

public class TestActiveObjectsWithOuterTx
extends EntityManagedActiveObjects {
    private static final Map<String, DatabaseType> DATABASE_PRODUCT_TO_TYPE_MAP = ImmutableMap.builder().put((Object)"H2", (Object)DatabaseType.H2).put((Object)"HSQL Database Engine", (Object)DatabaseType.HSQL).put((Object)"MySQL", (Object)DatabaseType.MYSQL).put((Object)"PostgreSQL", (Object)DatabaseType.POSTGRESQL).put((Object)"Oracle", (Object)DatabaseType.ORACLE).put((Object)"Microsoft SQL Server", (Object)DatabaseType.MS_SQL).put((Object)"DB2", (Object)DatabaseType.DB2).build();

    public TestActiveObjectsWithOuterTx(final EntityManager entityManager) {
        super(entityManager, new TransactionManager(){

            public <T> T doInTransaction(final TransactionCallback<T> callback) {
                try {
                    return new PropagationAwareTransaction<T>(entityManager){

                        public T run() {
                            return callback.doInTransaction();
                        }
                    }.execute();
                }
                catch (SQLException var3) {
                    throw new ActiveObjectsException((Throwable)var3);
                }
            }
        }, TestActiveObjectsWithOuterTx.findDatabaseType(entityManager));
    }

    private static DatabaseType findDatabaseType(EntityManager entityManager) {
        DatabaseType databaseType;
        Connection connection = null;
        try {
            Map.Entry<String, DatabaseType> entry;
            connection = entityManager.getProvider().getConnection();
            String dbName = connection.getMetaData().getDatabaseProductName();
            Iterator<Map.Entry<String, DatabaseType>> it = DATABASE_PRODUCT_TO_TYPE_MAP.entrySet().iterator();
            do {
                if (it.hasNext()) continue;
                DatabaseType databaseType2 = DatabaseType.UNKNOWN;
                return databaseType2;
            } while (!dbName.startsWith((entry = it.next()).getKey()));
            databaseType = entry.getValue();
        }
        catch (SQLException var15) {
            throw new ActiveObjectsException((Throwable)var15);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException var14) {
                    throw new ActiveObjectsException((Throwable)var14);
                }
            }
        }
        return databaseType;
    }

    public static abstract class PropagationAwareTransaction<T>
    extends Transaction<T> {
        public PropagationAwareTransaction(EntityManager manager) {
            super(manager);
        }

        public T execute() throws SQLException {
            return (T)this.run();
        }
    }
}

