/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.hamcrest.StashUserMatchers;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class PermittedUserMatchers {
    @Nonnull
    public static Matcher<PermittedUser> permittedUser(@Nullable Integer expectedUserId, @Nullable Permission expectedPermission) {
        return Matchers.allOf(PermittedUserMatchers.withUserId(expectedUserId), PermittedUserMatchers.withPermission(expectedPermission));
    }

    @Nonnull
    public static Matcher<PermittedUser> permittedUser(@Nullable String expectedUsername, @Nullable Permission expectedPermission) {
        return Matchers.allOf(PermittedUserMatchers.withUsername(expectedUsername), PermittedUserMatchers.withPermission(expectedPermission));
    }

    @Nonnull
    public static Matcher<PermittedUser> withUserId(@Nullable Integer expectedUserId) {
        return PermittedUserMatchers.withUserThat(StashUserMatchers.userWithId(expectedUserId));
    }

    @Nonnull
    public static Matcher<PermittedUser> withUsername(@Nullable String expectedUsername) {
        return PermittedUserMatchers.withUserThat(StashUserMatchers.userWithName(expectedUsername));
    }

    @Nonnull
    public static Matcher<PermittedUser> withUserThat(@Nonnull Matcher<ApplicationUser> userMatcher) {
        return new FeatureMatcher<PermittedUser, ApplicationUser>(userMatcher, "user that", "user"){

            protected ApplicationUser featureValueOf(PermittedUser actual) {
                return actual.getUser();
            }
        };
    }

    @Nonnull
    public static Matcher<PermittedUser> withPermission(@Nullable Permission expectedPermission) {
        return PermittedUserMatchers.withPermissionThat((Matcher<Permission>)Matchers.is((Object)expectedPermission));
    }

    @Nonnull
    public static Matcher<PermittedUser> withPermissionThat(@Nonnull Matcher<Permission> permissionMatcher) {
        return new FeatureMatcher<PermittedUser, Permission>(permissionMatcher, "permission that", "permission"){

            protected Permission featureValueOf(PermittedUser actual) {
                return actual.getPermission();
            }
        };
    }
}

