/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server;

import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleFeatureManager
implements FeatureManager {
    private final Map<Feature, Boolean> availableByFeature = new HashMap<Feature, Boolean>();
    private final Map<Feature, Boolean> enabledByFeature = new HashMap<Feature, Boolean>();

    public void clear() {
        this.availableByFeature.clear();
        this.enabledByFeature.clear();
    }

    public boolean isAvailable(@Nonnull Feature feature) {
        return this.availableByFeature.getOrDefault(feature, true);
    }

    public boolean isEnabled(@Nonnull Feature feature) {
        return this.isEnabled(feature, true);
    }

    public boolean isEnabled(@Nonnull Feature feature, boolean defaultValue) {
        return this.enabledByFeature.getOrDefault(feature, defaultValue);
    }

    public void setAvailable(@Nonnull Feature feature, boolean available) {
        this.availableByFeature.put(Objects.requireNonNull(feature, "feature"), available);
    }

    public void setEnabled(@Nonnull Feature feature, boolean enabled) {
        this.enabledByFeature.put(Objects.requireNonNull(feature, "feature"), enabled);
    }
}

