/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class StashUserMatchers {
    private StashUserMatchers() {
        throw new UnsupportedOperationException("Do not instantiate " + this.getClass().getSimpleName());
    }

    @Nonnull
    public static Matcher<ApplicationUser> stashUser(@Nullable Integer expectedId, @Nullable String expectedName) {
        return Matchers.allOf(StashUserMatchers.userWithId(expectedId), StashUserMatchers.userWithName(expectedName));
    }

    @Nonnull
    public static Matcher<ApplicationUser> userWithId(@Nullable Integer expectedId) {
        return StashUserMatchers.userWithIdThat((Matcher<Integer>)Matchers.is((Object)expectedId));
    }

    @Nonnull
    public static Matcher<ApplicationUser> userWithIdThat(@Nonnull Matcher<Integer> idMatcher) {
        Preconditions.checkNotNull(idMatcher, (Object)"idMatcher");
        return new FeatureMatcher<ApplicationUser, Integer>(idMatcher, "ID that", "id"){

            protected Integer featureValueOf(ApplicationUser actual) {
                return actual.getId();
            }
        };
    }

    @Nonnull
    public static Matcher<ApplicationUser> userWithName(@Nullable String expectedName) {
        return StashUserMatchers.userWithNameThat((Matcher<String>)Matchers.is((Object)expectedName));
    }

    @Nonnull
    public static Matcher<ApplicationUser> userWithNameThat(@Nonnull Matcher<String> nameMatcher) {
        Preconditions.checkNotNull(nameMatcher, (Object)"nameMatcher");
        return new FeatureMatcher<ApplicationUser, String>(nameMatcher, "name that", "name"){

            protected String featureValueOf(ApplicationUser actual) {
                return actual.getName();
            }
        };
    }
}

