/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class CommentThreadDiffAnchorMatchers {
    private CommentThreadDiffAnchorMatchers() {
        throw new UnsupportedOperationException(CommentThreadDiffAnchorMatchers.class.getName() + " should not be instantiated");
    }

    @Nonnull
    public static <A extends CommentThreadDiffAnchor> Matcher<A> withPath(@Nullable String path, @Nonnull Class<A> anchorClass) {
        return CommentThreadDiffAnchorMatchers.withPathThat((Matcher<String>)Matchers.is((Object)path), anchorClass);
    }

    @Nonnull
    public static <A extends CommentThreadDiffAnchor> Matcher<A> withPathThat(@Nonnull Matcher<String> pathMatcher, @Nonnull Class<A> anchorClass) {
        Preconditions.checkNotNull(pathMatcher, (Object)"pathMatcher");
        return new FeatureMatcher<A, String>(pathMatcher, "path", "path"){

            protected String featureValueOf(A anchor) {
                return anchor.getPath();
            }
        };
    }

    @Nonnull
    public static <A extends CommentThreadDiffAnchor> Matcher<A> withSrcPath(@Nullable String srcPath, @Nonnull Class<A> anchorClass) {
        return CommentThreadDiffAnchorMatchers.withSrcPathThat((Matcher<String>)Matchers.is((Object)srcPath), anchorClass);
    }

    @Nonnull
    public static <A extends CommentThreadDiffAnchor> Matcher<A> withSrcPathThat(@Nonnull Matcher<String> srcPathMatcher, @Nonnull Class<A> anchorClass) {
        Preconditions.checkNotNull(srcPathMatcher, (Object)"srcPathMatcher");
        return new FeatureMatcher<A, String>(srcPathMatcher, "srcPath", "srcPath"){

            protected String featureValueOf(A anchor) {
                return anchor.getSrcPath().orElse(null);
            }
        };
    }
}

