/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.junit;

import com.atlassian.bitbucket.util.MoreFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.rules.ExternalResource;

public class TemporaryDirectory
extends ExternalResource {
    private final Path parentDir;
    private Path dir;

    public TemporaryDirectory() {
        this(null);
    }

    public TemporaryDirectory(@Nullable Path parentDir) {
        this.parentDir = parentDir;
    }

    @Nonnull
    public Path getRoot() {
        if (this.dir == null) {
            throw new IllegalStateException("The temporary folder has not yet been created");
        }
        return this.dir;
    }

    @Nonnull
    public Path newFile() throws IOException {
        return Files.createTempFile(this.getRoot(), "junit", null, new FileAttribute[0]);
    }

    @Nonnull
    public Path newFile(@Nonnull String fileName) throws IOException {
        return Files.createFile(this.getRoot().resolve(fileName), new FileAttribute[0]);
    }

    @Nonnull
    public Path newFolder() throws IOException {
        return Files.createTempDirectory(this.getRoot(), "junit", new FileAttribute[0]);
    }

    @Nonnull
    public Path newFolder(@Nonnull String folderName) throws IOException {
        return Files.createDirectory(this.getRoot().resolve(folderName), new FileAttribute[0]);
    }

    @Nonnull
    public Path newFolder(String ... folderNames) throws IOException {
        Path file = this.getRoot();
        if (folderNames.length == 0) {
            return file;
        }
        if (folderNames.length == 1) {
            return this.newFolder(folderNames[0]);
        }
        String first = folderNames[0];
        String[] rest = new String[folderNames.length - 1];
        System.arraycopy(folderNames, 1, rest, 0, rest.length);
        file = file.resolve(Paths.get(first, rest));
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        return Files.createDirectory(file, new FileAttribute[0]);
    }

    protected void after() {
        if (this.dir != null) {
            MoreFiles.deleteQuietly((Path)this.dir);
        }
    }

    protected void before() throws IOException {
        this.dir = this.parentDir == null ? Files.createTempDirectory("junit", new FileAttribute[0]) : Files.createTempDirectory(this.parentDir, "junit", new FileAttribute[0]);
    }
}

