/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ParticipantMatchers {
    private ParticipantMatchers() {
        throw new UnsupportedOperationException(ParticipantMatchers.class.getName() + " should not be instantiated");
    }

    @Factory
    @Nonnull
    public static Matcher<InternalPullRequestParticipant> internalParticipant(ApplicationUser participant, PullRequestRole role) {
        return ParticipantMatchers.participant(participant, role);
    }

    @Factory
    @Nonnull
    public static Matcher<PullRequestParticipant> participant(final ApplicationUser participant, final PullRequestRole role) {
        return new TypeSafeMatcher<PullRequestParticipant>(){

            public boolean matchesSafely(PullRequestParticipant part) {
                return part.getUser().equals(participant) && part.getRole() == role;
            }

            public void describeTo(Description description) {
                description.appendText("Participant is a " + role);
                description.appendText("User is a " + participant);
            }
        };
    }
}

