/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rule;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatRule
implements TestRule {
    private static final Logger logger = LoggerFactory.getLogger(RepeatRule.class);
    private static final int REPEAT_LIMIT = Integer.getInteger("stash.test.repeat.count", 1);
    private final int count;

    public RepeatRule() {
        this(REPEAT_LIMIT);
    }

    public RepeatRule(int count) {
        this.count = count;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){
            int testRunCount = 0;

            public void evaluate() throws Throwable {
                for (int i = 0; i < RepeatRule.this.count; ++i) {
                    try {
                        ++this.testRunCount;
                        base.evaluate();
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.error("{}: Test run {} failed", new Object[]{description, i + 1, throwable});
                        throw throwable;
                    }
                }
                logger.info("{}: Test has run {} time{}.", new Object[]{description, this.testRunCount, this.testRunCount == 1 ? "" : "s"});
            }
        };
    }
}

