/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.Buffer;

public class SignatureECDSA
extends AbstractSignature {
    private static final String SIGNATURE_ALGORITHM_512 = "SHA512withECDSA";
    private static final String SIGNATURE_ALGORITHM_384 = "SHA384withECDSA";
    private static final String SIGNATURE_ALGORITHM_256 = "SHA256withECDSA";

    protected SignatureECDSA(String algo) {
        super(algo);
    }

    public static Signature getByCurveSize(ECParameterSpec params) {
        int curveSize = ECCurves.getCurveSize(params);
        if (curveSize <= 256) {
            return new SignatureECDSA(SIGNATURE_ALGORITHM_256);
        }
        if (curveSize <= 384) {
            return new SignatureECDSA(SIGNATURE_ALGORITHM_384);
        }
        return new SignatureECDSA(SIGNATURE_ALGORITHM_512);
    }

    public byte[] sign() throws Exception {
        int sPos;
        byte sLength;
        int rPos;
        byte rLength;
        byte[] sig = this.signature.sign();
        boolean longKey = false;
        if (sig[0] != 48) {
            throw new IOException("Invalid signature format");
        }
        if (sig[3] == 2 && sig[2] != 2) {
            longKey = true;
        }
        if (longKey) {
            rLength = sig[4];
            rPos = 5;
            sLength = sig[6 + rLength];
            sPos = 7 + rLength;
        } else {
            rLength = sig[3];
            rPos = 4;
            sLength = sig[5 + rLength];
            sPos = 6 + rLength;
        }
        if (longKey && (128 + sig[1]) * 128 + (128 + sig[2]) != sig.length - 3) {
            throw new IOException("Invalid signature format");
        }
        if (!longKey && sig[1] != sig.length - 2) {
            throw new IOException("Invalid signature format");
        }
        if (sPos > sig.length || sig[rPos + rLength] != 2) {
            throw new IOException("Invalid signature format");
        }
        if (sPos + sLength > sig.length) {
            throw new IOException("Invalid signature format");
        }
        byte[] rArray = new byte[rLength];
        byte[] sArray = new byte[sLength];
        System.arraycopy(sig, rPos, rArray, 0, rLength);
        System.arraycopy(sig, sPos, sArray, 0, sLength);
        BigInteger r = new BigInteger(rArray);
        BigInteger s = new BigInteger(sArray);
        Buffer rsBuf = new Buffer();
        rsBuf.putMPInt(r);
        rsBuf.putMPInt(s);
        return rsBuf.getCompactData();
    }

    public boolean verify(byte[] sig) throws Exception {
        sig = this.extractSig(sig);
        Buffer rsBuf = new Buffer(sig);
        byte[] rArray = rsBuf.getMPIntAsBytes();
        byte[] sArray = rsBuf.getMPIntAsBytes();
        if (rsBuf.available() != 0) {
            throw new IOException("Signature had padding");
        }
        int frst = (rArray[0] & 0x80) != 0 ? 1 : 0;
        int scnd = (sArray[0] & 0x80) != 0 ? 1 : 0;
        boolean longKey = false;
        int length = rArray.length + sArray.length + 6 + frst + scnd;
        if (length > 127) {
            longKey = true;
            ++length;
        }
        byte[] tmp = new byte[length];
        tmp[0] = 48;
        if (longKey) {
            tmp[1] = (byte)(rArray.length + sArray.length + 4 >> 7 ^ 0x80);
            tmp[2] = (byte)(rArray.length + sArray.length + 4 & 0xFF);
            tmp[2] = (byte)(tmp[2] + frst);
            tmp[2] = (byte)(tmp[2] + scnd);
            tmp[3] = 2;
            tmp[4] = (byte)rArray.length;
            tmp[4] = (byte)(tmp[4] + frst);
            System.arraycopy(rArray, 0, tmp, 5 + frst, rArray.length);
            tmp[5 + tmp[4]] = 2;
            tmp[6 + tmp[4]] = (byte)sArray.length;
            int n = 6 + tmp[4];
            tmp[n] = (byte)(tmp[n] + scnd);
            System.arraycopy(sArray, 0, tmp, 7 + tmp[4] + scnd, sArray.length);
            sig = tmp;
        } else {
            tmp[1] = (byte)(rArray.length + sArray.length + 4);
            tmp[1] = (byte)(tmp[1] + frst);
            tmp[1] = (byte)(tmp[1] + scnd);
            tmp[2] = 2;
            tmp[3] = (byte)rArray.length;
            tmp[3] = (byte)(tmp[3] + frst);
            System.arraycopy(rArray, 0, tmp, 4 + frst, rArray.length);
            tmp[4 + tmp[3]] = 2;
            tmp[5 + tmp[3]] = (byte)sArray.length;
            int n = 5 + tmp[3];
            tmp[n] = (byte)(tmp[n] + scnd);
            System.arraycopy(sArray, 0, tmp, 6 + tmp[3] + scnd, sArray.length);
            sig = tmp;
        }
        return this.signature.verify(sig);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NISTP521Factory
    implements NamedFactory<Signature> {
        @Override
        public String getName() {
            return "ecdsa-sha2-nistp521";
        }

        @Override
        public Signature create() {
            return new SignatureECDSA(SignatureECDSA.SIGNATURE_ALGORITHM_512);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NISTP384Factory
    implements NamedFactory<Signature> {
        @Override
        public String getName() {
            return "ecdsa-sha2-nistp384";
        }

        @Override
        public Signature create() {
            return new SignatureECDSA(SignatureECDSA.SIGNATURE_ALGORITHM_384);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NISTP256Factory
    implements NamedFactory<Signature> {
        @Override
        public String getName() {
            return "ecdsa-sha2-nistp256";
        }

        @Override
        public Signature create() {
            return new SignatureECDSA(SignatureECDSA.SIGNATURE_ALGORITHM_256);
        }
    }
}

