/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.stp;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.support.tools.spi.RootLevelSupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;
import org.apache.commons.lang3.StringUtils;

public class SshPluginInfo
extends RootLevelSupportInfoAppender {
    private static final String SSH = "stp.properties.stash.ssh";
    private static final String SSH_ACCESS_KEYS = "stp.properties.stash.ssh.access-keys";
    private static final String SSH_BASE_URL = "stp.properties.stash.ssh.base-url";
    private static final String SSH_ENABLED = "stp.properties.stash.ssh.enabled";
    private static final String SSH_NOT_CONFIGURED = "stp.properties.stash.ssh.not.configured";
    private static final String SSH_PORT = "stp.properties.stash.ssh.port";
    private final SshConfigurationService configurationService;
    private final I18nService i18nService;

    public SshPluginInfo(SshConfigurationService configurationService, I18nService i18nService) {
        this.configurationService = configurationService;
        this.i18nService = i18nService;
    }

    public void addSupportInfo(SupportInfoBuilder builder) {
        SshConfiguration configuration = this.configurationService.getConfiguration();
        builder.addCategory(SSH).addValue(SSH_ENABLED, String.valueOf(configuration.isEnabled())).addValue(SSH_PORT, String.valueOf(configuration.getPort())).addValue(SSH_BASE_URL, (String)StringUtils.defaultIfEmpty((CharSequence)configuration.getBaseUrl(), (CharSequence)this.i18nService.getMessage(SSH_NOT_CONFIGURED, new Object[0]))).addCategory(SSH_ACCESS_KEYS).addValue(SSH_ENABLED, String.valueOf(configuration.isAccessKeysEnabled()));
    }
}

