/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.service;

import com.atlassian.bitbucket.internal.ssh.service.SshBaseUrlResolver;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;

public class DefaultSshBaseUrlResolver
implements SshBaseUrlResolver {
    private final NavBuilder navBuilder;
    private final SshConfigurationService sshConfigurationService;

    public DefaultSshBaseUrlResolver(NavBuilder navBuilder, SshConfigurationService sshConfigurationService) {
        this.navBuilder = navBuilder;
        this.sshConfigurationService = sshConfigurationService;
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        SshConfiguration cfg = this.sshConfigurationService.getConfiguration();
        String baseUrl = cfg.getBaseUrl();
        if (baseUrl == null) {
            baseUrl = this.getDefaultBaseUrl();
        }
        return baseUrl;
    }

    @Override
    @Nonnull
    public String getDefaultBaseUrl() {
        try {
            String host = new URI(this.navBuilder.buildBaseUrl()).getHost();
            return String.format("ssh://%s:%s", host, this.sshConfigurationService.getConfiguration().getPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Base URL is not a valid URI");
        }
    }
}

