/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ssh.util.KeyUtils;
import com.google.common.collect.Iterables;
import java.io.File;
import java.security.KeyPair;
import javax.annotation.Nonnull;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;

public class DefaultHostKeyPairProvider
extends PEMGeneratorHostKeyProvider
implements HostKeyPairProvider {
    private static final String KEY_PAIR_FILE = "ssh-server-keys.pem";
    private String fingerprint;

    public DefaultHostKeyPairProvider(ApplicationPropertiesService service) {
        this.setPath(new File(service.getConfigDir(), KEY_PAIR_FILE).getAbsolutePath());
    }

    @Override
    @Nonnull
    public String getFingerprint() {
        if (this.fingerprint == null) {
            KeyPair keyPair = (KeyPair)Iterables.get(this.loadKeys(), (int)0);
            this.fingerprint = KeyUtils.calculateFingerprint(keyPair.getPublic());
        }
        return this.fingerprint;
    }
}

