/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.fragments;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SshClonePromptContextProvider
implements ContextProvider {
    private final AuthenticationContext authenticationContext;
    private final NavBuilder navBuilder;

    public SshClonePromptContextProvider(AuthenticationContext authenticationContext, NavBuilder navBuilder) {
        this.authenticationContext = authenticationContext;
        this.navBuilder = navBuilder;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            NavBuilder.PathBuilder path = this.navBuilder.pluginServlets().path(new String[]{"ssh", "account", "keys", "add"});
            Repository repository = (Repository)context.get("repository");
            if (repository != null) {
                String repositoryUrl = this.navBuilder.repo(repository).buildRelative();
                path.withParam("next", repositoryUrl);
            }
            String addKeyUrl = path.buildAbsolute();
            ImmutableMap.Builder mb = ImmutableMap.builder().put((Object)"addKeyUrl", (Object)addKeyUrl);
            return mb.build();
        }
        return context;
    }
}

