/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.command;

import com.atlassian.bitbucket.internal.ssh.command.SshCommandProvider;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandFactory;
import com.atlassian.bitbucket.ssh.command.SshCommandFactoryModuleDescriptor;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class PluginSshCommandProvider
implements SshCommandProvider {
    private final PluginAccessor pluginAccessor;

    public PluginSshCommandProvider(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public Optional<SshCommand> getSshCommand(@Nonnull String command, @Nonnull InputStream in, @Nonnull OutputStream out, @Nonnull OutputStream err) {
        return this.getHandlers().filter(handler -> handler.supports(command)).findFirst().flatMap(handler -> handler.create(command, in, out, err));
    }

    private Stream<SshCommandFactory> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SshCommandFactoryModuleDescriptor.class));
    }
}

