/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.rest;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.key.ssh.rest.RestSshAccessKey;
import com.atlassian.bitbucket.internal.key.ssh.rest.RestSshAccessKeyLocations;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.ssh.SetSshAccessKeyRequest;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="/")
public class SshAccessKeyResource {
    private static final String SUFFIX_SSH = "/ssh";
    private final SshAccessKeyService accessKeyService;
    private final I18nService i18nService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final Function<RestProject, Project> projectLookup = new Function<RestProject, Project>(){

        @Override
        public Project apply(RestProject restProj) {
            Project project = null;
            if (restProj.getId() > 0) {
                project = SshAccessKeyResource.this.projectService.getById(restProj.getId());
            }
            if (project == null && restProj.getKey() != null) {
                project = SshAccessKeyResource.this.projectService.getByKey(restProj.getKey());
            }
            if (project == null) {
                throw SshAccessKeyResource.this.newNoResourceFoundException();
            }
            return project;
        }
    };
    private Function<RestRepository, Repository> repositoryLookup = new Function<RestRepository, Repository>(){

        @Override
        public Repository apply(RestRepository restRepo) {
            Repository repo = null;
            if (restRepo.getId() > 0) {
                repo = SshAccessKeyResource.this.repositoryService.getById(restRepo.getId());
            }
            if (repo == null && restRepo.getSlug() != null && restRepo.getProject() != null && restRepo.getProject().getKey() != null) {
                repo = SshAccessKeyResource.this.repositoryService.getBySlug(restRepo.getProject().getKey(), restRepo.getSlug());
            }
            if (repo == null) {
                throw SshAccessKeyResource.this.newNoResourceFoundException();
            }
            return repo;
        }
    };

    public SshAccessKeyResource(SshAccessKeyService accessKeyService, I18nService i18nService, ProjectService projectService, RepositoryService repositoryService) {
        this.accessKeyService = accessKeyService;
        this.i18nService = i18nService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
    }

    @POST
    @Path(value="projects/{projectKey}/ssh")
    public Response addForProject(@Context Project project, RestSshAccessKey accessKey, @Context UriInfo uriInfo) {
        if (accessKey == null || !accessKey.hasKey()) {
            return ResponseFactory.badRequest((String)"Missing key").build();
        }
        try {
            RestSshKey key = accessKey.getKey();
            SshAccessKey result = this.accessKeyService.set(new SetSshAccessKeyRequest.Builder().key(accessKey.getKey().getText(), key.getLabel()).projectAccess(project, accessKey.hasPermission() ? accessKey.getPermission() : Permission.PROJECT_READ).build());
            URI uri = uriInfo.getRequestUriBuilder().replaceQuery(null).path(Integer.toString(accessKey.getKey().getId())).build(new Object[0]);
            return ResponseFactory.created((URI)uri).entity((Object)new RestSshAccessKey(result)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh")
    public Response addForRepository(@Context Repository repository, RestSshAccessKey accessKey, @Context UriInfo uriInfo) {
        if (accessKey == null || !accessKey.hasKey()) {
            return ResponseFactory.badRequest((String)"Missing key").build();
        }
        try {
            Permission permission = accessKey.getPermission();
            RestSshKey key = accessKey.getKey();
            SshAccessKey result = this.accessKeyService.set(new SetSshAccessKeyRequest.Builder().key(accessKey.getKey().getText(), key.getLabel()).repositoryAccess(repository, permission != null ? permission : Permission.REPO_READ).build());
            URI uri = uriInfo.getRequestUriBuilder().replaceQuery(null).path(Integer.toString(accessKey.getKey().getId())).build(new Object[0]);
            return ResponseFactory.created((URI)uri).entity((Object)new RestSshAccessKey(result)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="/ssh/{keyId}")
    public Response revokeMany(@PathParam(value="keyId") Integer keyId, RestSshAccessKeyLocations locations) {
        Collection<RestProject> projects = this.ensureAllLocationsNonNull("projects", locations.getProjects());
        Collection<RestRepository> repositories = this.ensureAllLocationsNonNull("repositories", locations.getRepositories());
        this.accessKeyService.revoke(keyId, repositories.stream().map(this.repositoryLookup).collect(Collectors.toSet()), projects.stream().map(this.projectLookup).collect(Collectors.toSet()));
        return Response.noContent().build();
    }

    @GET
    @Path(value="projects/{projectKey}/ssh")
    public Response getForProject(@Context Project project, @Context PageRequest pageRequest) {
        Page<SshAccessKey> page = this.accessKeyService.findByProject(project, pageRequest);
        return ResponseFactory.ok((Object)new RestPage(page, RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh")
    public Response getForRepository(@Context Repository repository, @Context PageRequest pageRequest) {
        Page<SshAccessKey> page = this.accessKeyService.findByRepository(repository, pageRequest);
        return ResponseFactory.ok((Object)new RestPage(page, RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="projects/{projectKey}/ssh/{keyId}")
    public Response getForProject(@Context Project project, @PathParam(value="keyId") Integer keyId) {
        return this.accessKeyService.getByKeyAndProject(keyId, project).map(accessKey -> ResponseFactory.ok((Object)((Object)new RestSshAccessKey((SshAccessKey)accessKey))).build()).orElse(this.notFound(project, keyId));
    }

    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh/{keyId}")
    public Response getForRepository(@Context Repository repository, @PathParam(value="keyId") Integer keyId) {
        return this.accessKeyService.getByKeyAndRepository(keyId, repository).map(accessKey -> ResponseFactory.ok((Object)((Object)new RestSshAccessKey((SshAccessKey)accessKey))).build()).orElse(this.notFound(repository, keyId));
    }

    @GET
    @Path(value="/ssh/{keyId}/projects")
    public Response getForProjects(@PathParam(value="keyId") Integer keyId, @Context PageRequest pageRequest) {
        return ResponseFactory.ok((Object)new RestPage(this.accessKeyService.findByKeyForProjects(keyId, pageRequest), RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="/ssh/{keyId}/repos")
    public Response getForRepositories(@PathParam(value="keyId") Integer keyId, @Context PageRequest pageRequest) {
        return ResponseFactory.ok((Object)new RestPage(this.accessKeyService.findByKeyForRepositories(keyId, pageRequest), RestSshAccessKey.REST_TRANSFORM)).build();
    }

    @DELETE
    @Path(value="projects/{projectKey}/ssh/{keyId}")
    public Response revokeForProject(@Context Project project, @PathParam(value="keyId") Integer keyId) {
        this.accessKeyService.revoke((int)keyId, project);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh/{keyId}")
    public Response revokeForRepository(@Context Repository repository, @PathParam(value="keyId") Integer keyId) {
        this.accessKeyService.revoke((int)keyId, repository);
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="projects/{projectKey}/ssh/{keyId}/permission/{permission}")
    public Response updatePermission(@Context Project project, @PathParam(value="keyId") Integer keyId, @PathParam(value="permission") Permission permission) {
        try {
            SshAccessKey accessKey = this.accessKeyService.set(new SetSshAccessKeyRequest.Builder().key(keyId).projectAccess(project, permission).build());
            return ResponseFactory.ok((Object)((Object)new RestSshAccessKey(accessKey))).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/ssh/{keyId}/permission/{permission}")
    public Response updatePermission(@Context Repository repository, @PathParam(value="keyId") Integer keyId, @PathParam(value="permission") Permission permission) {
        try {
            SshAccessKey accessKey = this.accessKeyService.set(new SetSshAccessKeyRequest.Builder().key(keyId).repositoryAccess(repository, permission).build());
            return ResponseFactory.ok((Object)((Object)new RestSshAccessKey(accessKey))).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getMessage()).build();
        }
    }

    private <T> Collection<T> ensureAllLocationsNonNull(String locationType, Collection<T> resources) {
        for (T resource : resources) {
            if (resource != null) continue;
            throw new BadRequestException(locationType, this.i18nService.getMessage("bitbucket.service.ssh.key.access.resource.null", new Object[]{locationType}));
        }
        return resources;
    }

    private Response notFound(String message) {
        return ResponseFactory.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestErrorMessage(message)).type("application/json;charset=UTF-8").build();
    }

    private Response notFound(Project project, Integer keyId) {
        return this.notFound(this.i18nService.getMessage("bitbucket.ssh.project.nosuchkeyaccess", new Object[]{keyId, project.getKey()}));
    }

    private Response notFound(Repository repository, Integer keyId) {
        return this.notFound(this.i18nService.getMessage("bitbucket.ssh.repo.nosuchkeyaccess", new Object[]{keyId, repository.getProject().getKey(), repository.getSlug()}));
    }

    private NoSuchEntityException newNoResourceFoundException() {
        throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.access.resource.notfound", new Object[0]));
    }
}

