/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.condition;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.ssh.server.SshServer;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class ShowUserSshCloneUrlCondition
implements Condition {
    private final AuthenticationContext authenticationContext;
    private final SshKeyService sshKeyService;
    private final SshServer sshServer;

    public ShowUserSshCloneUrlCondition(SshServer sshServer, SshKeyService sshKeyService, AuthenticationContext authenticationContext) {
        this.sshServer = sshServer;
        this.sshKeyService = sshKeyService;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (this.sshServer.isRunning()) {
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            return currentUser != null && this.sshKeyService.hasSshKey(currentUser);
        }
        return false;
    }
}

