/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.condition;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.ssh.server.SshServer;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class ShowUserAddSshKeyClonePromptCondition
implements Condition {
    private final AuthenticationContext authenticationContext;
    private final SshConfigurationService sshConfigurationService;
    private final SshKeyService sshKeyService;
    private final SshServer sshServer;

    public ShowUserAddSshKeyClonePromptCondition(AuthenticationContext authenticationContext, SshConfigurationService sshConfigurationService, SshKeyService sshKeyService, SshServer sshServer) {
        this.authenticationContext = authenticationContext;
        this.sshConfigurationService = sshConfigurationService;
        this.sshKeyService = sshKeyService;
        this.sshServer = sshServer;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        if (this.sshConfigurationService.getConfiguration().isEnabled() && this.sshServer.isRunning()) {
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            return currentUser != null && !this.sshKeyService.hasSshKey(currentUser);
        }
        return false;
    }
}

