/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.condition;

import com.atlassian.bitbucket.internal.ssh.server.SshServer;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class ShowAccessKeySshCloneUrlCondition
implements Condition {
    private static final String REPOSITORY = "repository";
    private final SshConfigurationService configurationService;
    private final SshAccessKeyService accessKeyService;
    private final SshServer sshServer;

    public ShowAccessKeySshCloneUrlCondition(SshAccessKeyService accessKeyService, SshServer sshServer, SshConfigurationService configurationService) {
        this.accessKeyService = accessKeyService;
        this.sshServer = sshServer;
        this.configurationService = configurationService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Object maybeRepository;
        if (this.sshServer.isRunning() && this.configurationService.getConfiguration().isAccessKeysEnabled() && (maybeRepository = context.get(REPOSITORY)) instanceof Repository) {
            Repository repository = (Repository)maybeRepository;
            return this.accessKeyService.existsForRepository(repository) || this.accessKeyService.existsForProject(repository.getProject());
        }
        return false;
    }
}

