/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SshAccessKeyUtils {
    static final int MAX_LENGTH_DISPLAY_NAME = 255;
    static final int MAX_LENGTH_KEY_IDENTIFIER = 64;

    @Nonnull
    public static String generateServiceUserDisplayName(@Nonnull I18nService i18nService, @Nonnull String keyText, @Nullable String keyLabel) {
        Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        Preconditions.checkNotNull((Object)keyText, (Object)"keyText");
        String keyIdentifier = StringUtils.isBlank((CharSequence)keyLabel) ? StringUtils.abbreviateMiddle((String)keyText, (String)"...", (int)64) : StringUtils.abbreviate((String)keyLabel, (int)64);
        String displayName = i18nService.createKeyedMessage("bitbucket.service.ssh.key.service.user.name", new Object[]{keyIdentifier}).getLocalisedMessage();
        if (displayName.length() > 255) {
            displayName = displayName.substring(0, 255);
        }
        return displayName;
    }
}

