/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.key.ssh.DefaultSshKeyService;
import com.atlassian.bitbucket.internal.key.ssh.SimpleSshAccessKey;
import com.atlassian.bitbucket.internal.key.ssh.SshAccessKeyUtils;
import com.atlassian.bitbucket.internal.key.ssh.ValidatingSshKey;
import com.atlassian.bitbucket.internal.ssh.InternalSshKeyService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ssh.DuplicateSshKeyException;
import com.atlassian.bitbucket.ssh.NoSuchSshKeyException;
import com.atlassian.bitbucket.ssh.SetSshAccessKeyRequest;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyAccessDisabledException;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyGrantedEvent;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyRevokedEvent;
import com.atlassian.bitbucket.ssh.event.SshKeyDeletedEvent;
import com.atlassian.bitbucket.ssh.util.KeyUtils;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.stash.experimental.user.ExperimentalPermissionAdminService;
import com.atlassian.stash.experimental.user.PermittedUserSearchRequest;
import com.atlassian.stash.experimental.user.ProjectPermissionRequest;
import com.atlassian.stash.experimental.user.ProjectPermissionSearchRequest;
import com.atlassian.stash.experimental.user.RepositoryPermissionRequest;
import com.atlassian.stash.experimental.user.RepositoryPermissionSearchRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSshAccessKeyService
implements SshAccessKeyService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSshAccessKeyService.class);
    static final int LIMIT_PAGE_SIZE = 50;
    private static final int BATCH_SIZE = 100;
    private static final EnumSet<Permission> REPO_ACCESS_KEY_PERMS = Sets.newEnumSet(Arrays.asList(Permission.REPO_READ, Permission.REPO_WRITE), Permission.class);
    private static final EnumSet<Permission> PROJECT_ACCESS_KEY_PERMS = Sets.newEnumSet(Arrays.asList(Permission.PROJECT_READ, Permission.PROJECT_WRITE), Permission.class);
    private final ActiveObjects ao;
    private final SshConfigurationService configurationService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final InternalSshKeyService keyService;
    private final ExperimentalPermissionAdminService permissionAdminService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;
    private final Validator validator;

    public DefaultSshAccessKeyService(SshConfigurationService configurationService, EventPublisher eventPublisher, I18nService i18nService, InternalSshKeyService keyService, ExperimentalPermissionAdminService permissionAdminService, PermissionService permissionService, PermissionValidationService permissionValidationService, SecurityService securityService, ActiveObjects ao, UserAdminService userAdminService, Validator validator) {
        this.ao = ao;
        this.configurationService = configurationService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.keyService = keyService;
        this.permissionAdminService = permissionAdminService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.validator = validator;
    }

    @Override
    public boolean existsForProject(@Nonnull Project project) {
        Preconditions.checkNotNull((Object)((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId(), (Object)"project.id");
        if (!this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return false;
        }
        return (Boolean)this.ao.executeInTransaction(() -> {
            Predicate<PermittedUser> serviceUserWithKeyPredicate = this.serviceUserWithSshKeyPredicate(Maps.newHashMap());
            PagedIterable usersWithPermission = new PagedIterable(request -> this.permissionAdminService.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.ProjectBuilder)new PermittedUserSearchRequest.Builder().project(project).userType(UserType.SERVICE)).build(), request), 50);
            return Iterables.any((Iterable)usersWithPermission, serviceUserWithKeyPredicate::test);
        });
    }

    @Override
    public boolean existsForRepository(@Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getId(), (Object)"repository.id");
        if (!this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN)) {
            return false;
        }
        return (Boolean)this.ao.executeInTransaction(() -> {
            Predicate<PermittedUser> serviceUserWithKeyPredicate = this.serviceUserWithSshKeyPredicate(Maps.newHashMap());
            PagedIterable usersWithPermission = new PagedIterable(request -> this.permissionAdminService.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.RepositoryBuilder)new PermittedUserSearchRequest.Builder().repository(repository).userType(UserType.SERVICE)).build(), request), 50);
            return Iterables.any((Iterable)usersWithPermission, serviceUserWithKeyPredicate::test);
        });
    }

    @Override
    @Nonnull
    public Page<SshAccessKey> findByKeyForProjects(int sshKeyId, @Nonnull PageRequest pageRequest) {
        return (Page)this.ao.executeInTransaction(() -> {
            SshKey key = this.getAndValidateServiceUserKey(sshKeyId);
            ApplicationUser serviceUser = key.getUser();
            EscalatedSecurityContext withAdmin = this.securityService.withPermission(Permission.ADMIN, "Read in key accesses before filtering on visibility");
            PageProvider projectPageProvider = innerPageRequest -> (Page)withAdmin.call(() -> this.findPermittedProjects(key, serviceUser, innerPageRequest));
            return this.filterForVisibility((PageProvider<SshAccessKey>)projectPageProvider, pageRequest);
        });
    }

    @Override
    @Nonnull
    public Page<SshAccessKey> findByKeyForRepositories(int sshKeyId, @Nonnull PageRequest pageRequest) {
        return (Page)this.ao.executeInTransaction(() -> {
            SshKey key = this.getAndValidateServiceUserKey(sshKeyId);
            ApplicationUser serviceUser = key.getUser();
            EscalatedSecurityContext withAdmin = this.securityService.withPermission(Permission.ADMIN, "Read in key accesses before filtering on visibility");
            PageProvider repositoryPageProvider = innerPageRequest -> (Page)withAdmin.call(() -> this.findPermittedRepositories(key, serviceUser, innerPageRequest));
            return this.filterForVisibility((PageProvider<SshAccessKey>)repositoryPageProvider, pageRequest);
        });
    }

    @Override
    @Nonnull
    public Page<SshAccessKey> findByProject(@Nonnull Project project, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId(), (Object)"project.id");
        this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        return (Page)this.ao.executeInTransaction(() -> {
            HashMap userIdToKeyCache = Maps.newHashMap();
            Predicate<PermittedUser> serviceUserWithKeyPredicate = this.serviceUserWithSshKeyPredicate(userIdToKeyCache);
            Page permittedUserPage = PageUtils.filterPages(request -> this.permissionAdminService.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.ProjectBuilder)new PermittedUserSearchRequest.Builder().project(project).userType(UserType.SERVICE)).build(), request), serviceUserWithKeyPredicate, (PageRequest)this.limit(pageRequest));
            return this.toAccessKey((Page<PermittedUser>)permittedUserPage, project, (Map<Integer, SshKey>)userIdToKeyCache);
        });
    }

    @Override
    @Nonnull
    public Page<SshAccessKey> findByRepository(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getId(), (Object)"repository.id");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        return (Page)this.ao.executeInTransaction(() -> {
            HashMap userIdToKeyCache = Maps.newHashMap();
            Predicate<PermittedUser> anonUserWithKeyPredicate = this.serviceUserWithSshKeyPredicate(userIdToKeyCache);
            Page permittedUserPage = PageUtils.filterPages(request -> this.permissionAdminService.searchUsers((PermittedUserSearchRequest)((PermittedUserSearchRequest.RepositoryBuilder)new PermittedUserSearchRequest.Builder().repository(repository).userType(UserType.SERVICE)).build(), request), anonUserWithKeyPredicate, (PageRequest)this.limit(pageRequest));
            return this.toAccessKey((Page<PermittedUser>)permittedUserPage, repository, (Map<Integer, SshKey>)userIdToKeyCache);
        });
    }

    @Override
    @Nonnull
    public Optional<SshAccessKey> getByKeyAndProject(int sshKeyId, @Nonnull Project project) {
        Preconditions.checkNotNull((Object)((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId(), (Object)"project.id");
        this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        return (Optional)this.ao.executeInTransaction(() -> this.internalGetByProjectAndKey(sshKeyId, project, false));
    }

    @Override
    @Nonnull
    public Optional<SshAccessKey> getByKeyAndRepository(int sshKeyId, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getId(), (Object)"repository.id");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        return (Optional)this.ao.executeInTransaction(() -> this.internalGetByRepositoryAndKey(sshKeyId, repository, false));
    }

    @Override
    public void revoke(int sshKeyId, @Nonnull Project project) {
        Preconditions.checkNotNull((Object)project, (Object)"project");
        Preconditions.checkNotNull((Object)((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId(), (Object)"project.id");
        this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        this.ao.executeInTransaction(() -> {
            this.internalGetByProjectAndKey(sshKeyId, project, true).ifPresent(accessKey -> {
                ApplicationUser serviceUser = accessKey.getKey().getUser();
                this.permissionAdminService.revokeAllProjectPermissions(project, serviceUser);
                log.debug("Access to project \"{}\" has been revoked for service user {}", (Object)project, (Object)serviceUser.getDisplayName());
                this.publish(new SshAccessKeyRevokedEvent(this, (SshAccessKey)accessKey));
                this.keyService.removeIfOrphaned(accessKey.getKey(), serviceUser);
            });
            return null;
        });
    }

    @Override
    public void revoke(int sshKeyId, @Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getId(), (Object)"repository.id");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.ao.executeInTransaction(() -> {
            this.internalGetByRepositoryAndKey(sshKeyId, repository, true).ifPresent(accessKey -> {
                ApplicationUser serviceUser = accessKey.getKey().getUser();
                this.permissionAdminService.revokeAllRepositoryPermissions(repository, serviceUser);
                log.debug("Access to repository \"{}\" has been revoked for service user {}", (Object)repository, (Object)serviceUser.getDisplayName());
                this.publish(new SshAccessKeyRevokedEvent(this, (SshAccessKey)accessKey));
                this.keyService.removeIfOrphaned(accessKey.getKey(), serviceUser);
            });
            return null;
        });
    }

    @Override
    public void revoke(int sshKeyId, @Nonnull Set<Repository> repositories, @Nonnull Set<Project> projects) {
        Preconditions.checkNotNull(repositories, (Object)"repositories");
        Preconditions.checkNotNull(projects, (Object)"projects");
        this.validateIsAdminOfRepos(repositories);
        this.validateIsAdminOfProjects(projects);
        SshKey key = this.getServiceUserKey(sshKeyId);
        if (key == null) {
            return;
        }
        ApplicationUser serviceUser = key.getUser();
        ImmutableList resources = ImmutableList.builder().addAll(projects).addAll(repositories).build();
        if (!resources.isEmpty()) {
            for (List batch : Chainable.chain((Iterable)resources).partition(100)) {
                this.ao.executeInTransaction(() -> {
                    for (Object resource : batch) {
                        if (resource instanceof Project) {
                            this.permissionAdminService.revokeAllProjectPermissions((Project)resource, serviceUser);
                            continue;
                        }
                        this.permissionAdminService.revokeAllRepositoryPermissions((Repository)resource, serviceUser);
                    }
                    this.keyService.removeIfOrphaned(key, serviceUser);
                    return null;
                });
            }
        }
    }

    @Override
    @Nonnull
    public SshAccessKey set(final @Nonnull SetSshAccessKeyRequest request) {
        if (!this.isAccessKeysEnabled()) {
            throw new SshKeyAccessDisabledException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.access.disabled", new Object[0]));
        }
        if (request.getKeyId() == null) {
            ValidationUtils.validate((Validator)this.validator, (Object)new ValidatingSshKey(request.getKeyText()), (Class[])new Class[0]);
        }
        this.permissionValidationService.validateAuthenticated();
        return (SshAccessKey)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<SshAccessKey>(){

            public SshAccessKey doInTransaction() {
                SimpleSshAccessKey accessKey;
                SshKey key = request.getKeyId() == null ? DefaultSshAccessKeyService.this.getOrCreateServiceUserKey(request.getKeyText(), request.getKeyLabel()) : DefaultSshAccessKeyService.this.getAndValidateServiceUserKey(request.getKeyId());
                SetPermissionRequest.Builder permRequestBuilder = new SetPermissionRequest.Builder().user(key.getUser());
                Project project = request.getProject();
                if (project != null) {
                    Permission existingPerm = DefaultSshAccessKeyService.this.permissionAdminService.getProjectPermission(((ProjectPermissionRequest.Builder)new ProjectPermissionRequest.Builder().user(key.getUser())).project(project).build());
                    if (existingPerm != null && existingPerm == request.getPermission()) {
                        throw new DuplicateSshKeyException(DefaultSshAccessKeyService.this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.project.inuse", new Object[0]));
                    }
                    DefaultSshAccessKeyService.this.permissionAdminService.setPermission(permRequestBuilder.projectPermission(request.getPermission(), project).build());
                    log.debug("Service user {} added ssh access key for project \"{}\"", (Object)key.getUser().getName(), (Object)project);
                    accessKey = new SimpleSshAccessKey(key, project, request.getPermission());
                } else {
                    Repository repository = request.getRepository();
                    Permission existingPerm = DefaultSshAccessKeyService.this.permissionAdminService.getRepositoryPermission(((RepositoryPermissionRequest.Builder)new RepositoryPermissionRequest.Builder().user(key.getUser())).repository(repository).build());
                    if (existingPerm != null && existingPerm == request.getPermission()) {
                        throw new DuplicateSshKeyException(DefaultSshAccessKeyService.this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.repository.inuse", new Object[0]));
                    }
                    DefaultSshAccessKeyService.this.permissionAdminService.setPermission(permRequestBuilder.repositoryPermission(request.getPermission(), repository).build());
                    log.debug("Service user {} added ssh access key for repository \"{}\"", (Object)key.getUser().getName(), (Object)repository);
                    accessKey = new SimpleSshAccessKey(key, repository, request.getPermission());
                }
                DefaultSshAccessKeyService.this.publish(new SshAccessKeyGrantedEvent(this, accessKey));
                return accessKey;
            }
        });
    }

    @EventListener
    public void onSshKeyDeleted(SshKeyDeletedEvent keyDeletedEvent) {
        SshKey key = keyDeletedEvent.getKey();
        if (this.isAccessKeyUser(key.getUser())) {
            this.securityService.withPermission(Permission.ADMIN, "Revoking all permissions for access key user because their SSH key has been deleted").call(() -> {
                this.permissionAdminService.revokeAllUserPermissions(key.getUser());
                return null;
            });
        }
    }

    private Optional<SshAccessKey> internalGetByProjectAndKey(int sshKeyId, Project project, boolean validate) {
        SshKey key;
        SshKey sshKey = key = validate ? this.getAndValidateServiceUserKey(sshKeyId) : this.getServiceUserKey(sshKeyId);
        if (key == null) {
            return Optional.empty();
        }
        ApplicationUser serviceUser = key.getUser();
        Permission permission = this.permissionAdminService.getProjectPermission(((ProjectPermissionRequest.Builder)new ProjectPermissionRequest.Builder().user(serviceUser)).project(project).build());
        return permission == null || !PROJECT_ACCESS_KEY_PERMS.contains(permission) ? Optional.empty() : Optional.of(new SimpleSshAccessKey(key, project, permission));
    }

    private Optional<SshAccessKey> internalGetByRepositoryAndKey(int sshKeyId, Repository repository, boolean validate) {
        SshKey key;
        SshKey sshKey = key = validate ? this.getAndValidateServiceUserKey(sshKeyId) : this.getServiceUserKey(sshKeyId);
        if (key == null) {
            return Optional.empty();
        }
        ApplicationUser serviceUser = key.getUser();
        Permission permission = this.permissionAdminService.getRepositoryPermission(((RepositoryPermissionRequest.Builder)new RepositoryPermissionRequest.Builder().user(serviceUser)).repository(repository).build());
        return permission == null || !REPO_ACCESS_KEY_PERMS.contains(permission) ? Optional.empty() : Optional.of(new SimpleSshAccessKey(key, repository, permission));
    }

    private boolean isAccessKeysEnabled() {
        return this.configurationService.getConfiguration().isAccessKeysEnabled();
    }

    private boolean isAccessKeyUser(ApplicationUser user) {
        return user != null && (Boolean)user.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<Boolean>(){

            public Boolean visit(@Nonnull ServiceUser user) {
                return "access-key".equals(user.getLabel());
            }

            protected Boolean defaultValue(@Nonnull ApplicationUser user) {
                return false;
            }
        }) != false;
    }

    private PageRequest limit(PageRequest pageRequest) {
        return pageRequest == null ? new PageRequestImpl(0, 50) : pageRequest.buildRestrictedPageRequest(50);
    }

    private void publish(SshAccessKeyEvent event) {
        this.eventPublisher.publish((Object)event);
    }

    private SshKey getAndValidateServiceUserKey(int sshKeyId) {
        SshKey key = this.keyService.getById(sshKeyId);
        if (key == null || !this.isAccessKeyUser(key.getUser())) {
            throw new NoSuchSshKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.nosuchkey", new Object[]{sshKeyId}));
        }
        return key;
    }

    private SshKey getServiceUserKey(int sshKeyId) {
        SshKey key = this.keyService.getById(sshKeyId);
        if (key != null && !this.isAccessKeyUser(key.getUser())) {
            return null;
        }
        return key;
    }

    private SshKey getOrCreateServiceUserKey(String keyText, String label) {
        PublicKey publicKey = KeyUtils.getPublicKey(keyText);
        SshKey key = this.keyService.getByPublicKey(publicKey);
        if (key != null) {
            ApplicationUser user = key.getUser();
            if (user == null) {
                this.keyService.remove(key.getId());
                key = null;
            } else if (!this.isAccessKeyUser(user)) {
                throw new DuplicateSshKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.duplicate", new Object[]{user.getName()}));
            }
        }
        if (key == null) {
            ServiceUser serviceUser = this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().active(true)).displayName(SshAccessKeyUtils.generateServiceUserDisplayName(this.i18nService, keyText, label))).label("access-key")).build());
            key = this.keyService.addForUser((ApplicationUser)serviceUser, keyText, label);
        }
        return key;
    }

    private boolean isAdminOfResource(SshAccessKey accessKey) {
        Object resource = accessKey.getResource();
        if (resource instanceof Project) {
            return this.permissionService.hasProjectPermission((Project)resource, Permission.PROJECT_ADMIN);
        }
        if (resource instanceof Repository) {
            return this.permissionService.hasRepositoryPermission((Repository)resource, Permission.REPO_ADMIN);
        }
        throw new IllegalArgumentException("Unexpected access key resource type: " + resource.getClass().getName());
    }

    private Page<SshAccessKey> toAccessKey(Page<PermittedUser> page, Project project, Map<Integer, SshKey> userIdToKeyCache) {
        return page.transform(value -> new SimpleSshAccessKey((SshKey)userIdToKeyCache.get(value.getUser().getId()), project, value.getPermission()));
    }

    private Page<SshAccessKey> toAccessKey(Page<PermittedUser> page, Repository repository, Map<Integer, SshKey> userIdToKeyCache) {
        return page.transform(value -> new SimpleSshAccessKey((SshKey)userIdToKeyCache.get(value.getUser().getId()), repository, value.getPermission()));
    }

    private Predicate<PermittedUser> serviceUserWithSshKeyPredicate(Map<Integer, SshKey> userIdToKeyCache) {
        return value -> {
            ApplicationUser user = value.getUser();
            if (user.getType() == UserType.NORMAL) {
                return false;
            }
            SshKey key = userIdToKeyCache.computeIfAbsent(user.getId(), userId -> (SshKey)Iterables.getOnlyElement((Iterable)this.keyService.findAllForUser(value.getUser(), DefaultSshKeyService.PAGE_REQUEST_OF_1).getValues(), null));
            return key != null;
        };
    }

    private void validateIsAdminOfProjects(Collection<Project> projects) {
        for (Project project : projects) {
            this.permissionValidationService.validateForProject(project, Permission.PROJECT_ADMIN);
        }
    }

    private void validateIsAdminOfRepos(Collection<Repository> repositories) {
        for (Repository repository : repositories) {
            this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        }
    }

    private Page<SshAccessKey> filterForVisibility(PageProvider<SshAccessKey> provider, PageRequest pageRequest) {
        return PageUtils.filterPages(provider, this::isAdminOfResource, (PageRequest)this.limit(pageRequest));
    }

    private Page<SshAccessKey> findPermittedProjects(SshKey key, ApplicationUser serviceUser, PageRequest pageRequest) {
        return this.permissionAdminService.searchProjects(((ProjectPermissionSearchRequest.Builder)new ProjectPermissionSearchRequest.Builder().user(serviceUser)).build(), pageRequest).transform(projectPermission -> new SimpleSshAccessKey(key, projectPermission.getProject(), projectPermission.getPermission()));
    }

    private Page<SshAccessKey> findPermittedRepositories(SshKey key, ApplicationUser serviceUser, PageRequest pageRequest) {
        return this.permissionAdminService.searchRepositories(((RepositoryPermissionSearchRequest.Builder)new RepositoryPermissionSearchRequest.Builder().user(serviceUser)).build(), pageRequest).transform(repositoryPermission -> new SimpleSshAccessKey(key, repositoryPermission.getRepository(), repositoryPermission.getPermission()));
    }
}

