/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDescriptorUtils {
    private static final Logger log = LoggerFactory.getLogger(ModuleDescriptorUtils.class);

    private ModuleDescriptorUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static <T, M extends ModuleDescriptor<T>> Function<M, T> toModule() {
        return input -> {
            try {
                return input.getModule();
            }
            catch (Exception e) {
                log.info("Could not instantiate module {}", (Object)input.getCompleteKey(), (Object)(log.isDebugEnabled() ? e : null));
                return null;
            }
        };
    }

    public static <T, M extends ModuleDescriptor<T>> Stream<T> toModules(Collection<M> descriptors) {
        return ModuleDescriptorUtils.toModules(descriptors.stream());
    }

    public static <T, M extends ModuleDescriptor<T>> Stream<T> toModules(Stream<M> descriptors) {
        return descriptors.map(ModuleDescriptorUtils.toModule()).filter(Objects::nonNull);
    }

    public static <T, M extends BaseWeightedModuleDescriptor<T>> Stream<T> toSortedModules(Collection<M> descriptors) {
        return ModuleDescriptorUtils.toSortedModules(descriptors.stream());
    }

    public static <T, M extends BaseWeightedModuleDescriptor<T>> Stream<T> toSortedModules(Stream<M> descriptors) {
        return ModuleDescriptorUtils.toModules(descriptors.sorted());
    }
}

