/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.scm.pull.BulkRescopeContext;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BulkRescopeCommandParameters
extends AbstractCommandParameters {
    private final Repository repository;
    private final BulkRescopeContext rescopeContext;

    private BulkRescopeCommandParameters(BulkRescopeContext rescopeContext, Repository repository) {
        this.repository = repository;
        this.rescopeContext = rescopeContext;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public BulkRescopeContext getRescopeContext() {
        return this.rescopeContext;
    }

    public static class Builder {
        private Repository repository;
        private BulkRescopeContext rescopeContext;

        public Builder() {
        }

        public Builder(@Nonnull BulkRescopeCommandParameters parameters) {
            this();
            this.repository = parameters.getRepository();
            this.rescopeContext = parameters.getRescopeContext();
        }

        @Nonnull
        public BulkRescopeCommandParameters build() {
            Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"The repository for which pull requests should be rescoped is required");
            Preconditions.checkState((this.rescopeContext != null ? 1 : 0) != 0, (Object)"The bulk rescope context is required");
            return new BulkRescopeCommandParameters(this.rescopeContext, this.repository);
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            this.repository = Objects.requireNonNull(value, "repository");
            return this;
        }

        @Nonnull
        public Builder rescopeContext(@Nonnull BulkRescopeContext value) {
            this.rescopeContext = Objects.requireNonNull(value, "rescopeContext");
            return this;
        }
    }
}

