/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.PluginCommandBuilderFactory;
import com.atlassian.bitbucket.scm.PluginCommandFactory;
import com.atlassian.bitbucket.scm.PluginExtendedCommandFactory;
import com.atlassian.bitbucket.scm.PluginMergeStrategies;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmStatus;
import com.atlassian.bitbucket.scm.bulk.PluginBulkContentCommandFactory;
import com.atlassian.bitbucket.scm.compare.PluginCompareCommandFactory;
import com.atlassian.bitbucket.scm.integrity.PluginIntegrityCheckCommandFactory;
import com.atlassian.bitbucket.scm.mirror.PluginMirrorCommandFactory;
import com.atlassian.bitbucket.scm.pull.PluginPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.ref.PluginRefCommandFactory;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Scm {
    @Nullable
    default public PluginBulkContentCommandFactory getBulkContentCommandFactory() {
        return null;
    }

    @Nullable
    default public PluginCommandBuilderFactory getCommandBuilderFactory() {
        return null;
    }

    @Nonnull
    public PluginCommandFactory getCommandFactory();

    @Nullable
    default public PluginCompareCommandFactory getCompareCommandFactory() {
        return null;
    }

    @Nonnull
    default public MinimalRef getDefaultBranch(@Nonnull Repository repository) {
        try {
            return (MinimalRef)this.getCommandFactory().defaultBranch(repository).call();
        }
        catch (NoDefaultBranchException e) {
            String name = e.getBranchName();
            if (name == null) {
                throw new IllegalStateException(repository + " has no default branch");
            }
            return ((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(name)).type((RefType)StandardRefType.BRANCH).build();
        }
    }

    @Nullable
    default public PluginExtendedCommandFactory getExtendedCommandFactory() {
        return null;
    }

    @Nonnull
    public Set<ScmFeature> getFeatures();

    @Nullable
    default public PluginIntegrityCheckCommandFactory getIntegrityCheckCommandFactory() {
        return null;
    }

    @Nonnull
    public String getId();

    @Nullable
    default public PluginMergeStrategies getMergeStrategies() {
        return null;
    }

    @Nullable
    default public PluginMirrorCommandFactory getMirrorCommandFactory() {
        return null;
    }

    @Nonnull
    public String getName();

    @Nullable
    default public PluginPullRequestCommandFactory getPullRequestCommandFactory() {
        return null;
    }

    @Nullable
    default public PluginRefCommandFactory getRefCommandFactory() {
        return null;
    }

    @Nonnull
    public ScmStatus getStatus();

    public boolean isEmpty(@Nonnull Repository var1);
}

