/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.migration.Exporter;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MigrationHandlerModuleDescriptor
extends BaseWeightedModuleDescriptor<Void> {
    public static final String XML_ELEMENT_NAME = "migration-handler";
    private final NestedModuleDescriptor<Exporter> exporter;
    private volatile NestedModuleDescriptor<Importer> importer;

    public MigrationHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 100);
        this.exporter = new NestedModuleDescriptor(moduleFactory);
        this.importer = new NestedModuleDescriptor(moduleFactory);
    }

    public void disabled() {
        this.exporter.disabled();
        if (this.importer != null) {
            this.importer.disabled();
        }
    }

    @Nonnull
    public Exporter getExporter() {
        return this.exporter.getModule();
    }

    @Nonnull
    public Optional<Importer> getImporter() {
        return Optional.ofNullable(this.importer).map(NestedModuleDescriptor::getModule);
    }

    public Void getModule() {
        return null;
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.canOnlyHaveOneChildElementOfName(element, "exporter");
        this.canOnlyHaveOneChildElementOfName(element, "importer");
        Element exporterElement = element.element("exporter");
        if (exporterElement == null) {
            throw new PluginParseException("Element <migration-handler> needs to define an <exporter> child element");
        }
        this.exporter.init(plugin, exporterElement);
        Element importerElement = element.element("importer");
        if (importerElement == null) {
            this.importer = null;
        } else {
            this.importer.init(plugin, importerElement);
        }
    }

    private void canOnlyHaveOneChildElementOfName(@Nonnull Element element, @Nonnull String childElementName) {
        if (element.elements(childElementName).size() > 1) {
            throw new PluginParseException("Element <migration-handler> can only have one <" + childElementName + "> child element");
        }
    }

    private static class NestedModuleDescriptor<T>
    extends AbstractModuleDescriptor<T> {
        private volatile T module;

        public NestedModuleDescriptor(ModuleFactory moduleFactory) {
            super(moduleFactory);
        }

        public void disabled() {
            if (this.module instanceof StateAware) {
                ((StateAware)this.module).disabled();
            }
            this.module = null;
            super.disabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getModule() {
            if (this.module == null) {
                NestedModuleDescriptor nestedModuleDescriptor = this;
                synchronized (nestedModuleDescriptor) {
                    if (this.module == null) {
                        this.module = this.moduleFactory.createModule(this.getModuleClassName(), (ModuleDescriptor)this);
                    }
                }
            }
            return this.module;
        }

        protected void validate(Element element) {
            if (element.attributeValue("class") == null) {
                throw new ValidationException(List.of("The 'class' attribute is required: " + element.getName()));
            }
        }
    }
}

