/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleAuthentication
implements Authentication {
    private final Map<String, Serializable> properties;
    private final ApplicationUser user;

    private SimpleAuthentication(Builder builder) {
        this.properties = builder.properties.build();
        this.user = builder.user;
    }

    @Nonnull
    public static Builder builder(@Nullable ApplicationUser user) {
        return new Builder(user);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleAuthentication that = (SimpleAuthentication)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.properties, that.properties);
    }

    @Nonnull
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    @Nonnull
    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.user);
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Serializable> properties;
        private final ApplicationUser user;

        public Builder(@Nullable ApplicationUser user) {
            this.user = user;
            this.properties = ImmutableMap.builder();
        }

        @Nonnull
        public Authentication build() {
            return new SimpleAuthentication(this);
        }

        @Nonnull
        public Builder property(@Nonnull String key, @Nonnull Serializable value) {
            this.properties.put((Object)Objects.requireNonNull(key, "key"), (Object)Objects.requireNonNull(value, "value"));
            return this;
        }

        @Nonnull
        public Builder properties(@Nonnull Map<String, Serializable> values) {
            this.properties.putAll(Objects.requireNonNull(values, "properties"));
            return this;
        }
    }
}

