/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.throttle;

import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledScmRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(ThrottledScmRequestFactory.class);
    @VisibleForTesting
    static final String RESOURCE_NAME = "scm-hosting";
    private final ThrottleService throttleService;

    public ThrottledScmRequestFactory(ThrottleService throttleService) {
        this.throttleService = (ThrottleService)Preconditions.checkNotNull((Object)throttleService, (Object)"throttleService");
    }

    @Nonnull
    public SshScmRequest throttled(@Nonnull SshScmRequest request) {
        return this.throttled((ScmRequest)Preconditions.checkNotNull((Object)request, (Object)"request"), SshScmRequest.class);
    }

    @Nonnull
    public HttpScmRequest throttled(@Nonnull HttpScmRequest request) {
        return this.throttled((ScmRequest)Preconditions.checkNotNull((Object)request, (Object)"request"), HttpScmRequest.class);
    }

    private <T extends ScmRequest> T throttled(@Nonnull T request, Class<T> clazz) {
        return (T)((ScmRequest)clazz.cast(Proxy.newProxyInstance(request.getClass().getClassLoader(), ClassUtils.getAllInterfaces(request.getClass()).toArray(new Class[0]), (InvocationHandler)new ThrottlingInvocationHandler(request))));
    }

    private static class FutureUnlockingInvocationHandler
    implements InvocationHandler {
        private final Object target;
        private final Ticket ticket;
        private final long ticketOwnerThreadId;
        private volatile boolean released;

        FutureUnlockingInvocationHandler(@Nonnull Object target, @Nonnull Ticket ticket) {
            this.target = Objects.requireNonNull(target, "target");
            this.ticket = Objects.requireNonNull(ticket, "ticket");
            this.ticketOwnerThreadId = Thread.currentThread().getId();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object result = method.invoke(this.target, args);
                if ("get".equals(method.getName()) || "isDone".equals(method.getName()) && Boolean.TRUE.equals(result) || "cancel".equals(method.getName())) {
                    this.releaseTicket();
                }
                return result;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof ExecutionException || cause instanceof CancellationException || cause instanceof InterruptedException) {
                    this.releaseTicket();
                }
                throw cause;
            }
        }

        private void releaseTicket() {
            if (!this.released && Thread.currentThread().getId() == this.ticketOwnerThreadId) {
                try {
                    this.ticket.close();
                }
                catch (IllegalStateException e) {
                    log.warn("Failed to release ticket", (Throwable)e);
                }
                this.released = true;
            }
        }
    }

    private class ThrottlingInvocationHandler
    implements InvocationHandler {
        private final ScmRequest target;

        private ThrottlingInvocationHandler(ScmRequest target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("handleRequest".equals(method.getName())) {
                    return this.handleRequestThrottled(method, args);
                }
                if ("startRequest".equals(method.getName())) {
                    return this.startRequestThrottled(method, args);
                }
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Object handleRequestThrottled(Method method, Object[] args) throws Throwable {
            try (Ticket ignored = ThrottledScmRequestFactory.this.throttleService.acquireTicket(ThrottledScmRequestFactory.RESOURCE_NAME);){
                Object object = method.invoke((Object)this.target, args);
                return object;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object startRequestThrottled(Method method, Object[] args) throws Throwable {
            Ticket ticket = ThrottledScmRequestFactory.this.throttleService.acquireTicket(ThrottledScmRequestFactory.RESOURCE_NAME);
            Object future = null;
            try {
                future = method.invoke((Object)this.target, args);
                Object object = Proxy.newProxyInstance(this.target.getClass().getClassLoader(), new Class[]{Future.class}, (InvocationHandler)new FutureUnlockingInvocationHandler(future, ticket));
                return object;
            }
            finally {
                if (future == null) {
                    ticket.close();
                }
            }
        }
    }
}

