/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.utils.process.BaseProcessHandler;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.Watchdog;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;

class SummarizingProcessHandler
extends BaseProcessHandler {
    private final InputStreamHandler errorHandler;
    private final OutputStreamHandler inputHandler;
    private final InputStreamHandler outputHandler;
    private boolean canceled;
    private boolean complete;
    private ProcessException exception;
    private int exitCode;

    SummarizingProcessHandler(InputHandler inputHandler, OutputHandler outputHandler, OutputHandler errorHandler) {
        this.errorHandler = DelegatingInputStreamHandler.wrap(errorHandler);
        this.inputHandler = DelegatingOutputStreamHandler.wrap(inputHandler);
        this.outputHandler = DelegatingInputStreamHandler.wrap(outputHandler);
    }

    public void complete(int exitCode, boolean canceled, ProcessException exception) {
        CommandSummary.Builder builder;
        if (canceled) {
            builder = new CommandSummary.Builder(CommandResult.CANCELED);
        } else if (exitCode != 0 || exception != null) {
            if (exception == null) {
                exception = new ProcessException("Non-zero exit code: " + exitCode, exitCode);
            }
            builder = new CommandSummary.Builder(CommandResult.FAILED);
        } else {
            builder = new CommandSummary.Builder(CommandResult.SUCCEEDED);
        }
        CommandSummary summary = builder.build();
        this.complete = true;
        this.canceled = canceled;
        this.exception = exception;
        this.exitCode = exitCode;
        this.fireComplete(this.outputHandler, summary);
        this.fireComplete(this.errorHandler, summary);
        this.fireComplete(this.inputHandler, summary);
    }

    public ProcessException getException() {
        return this.exception;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean hasInput() {
        return this.inputHandler.isSet();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void processError(InputStream processError) throws ProcessException {
        this.errorHandler.process(processError, this.getWatchdog());
    }

    public void processOutput(InputStream processOutput) throws ProcessException {
        this.outputHandler.process(processOutput, this.getWatchdog());
    }

    public void provideInput(OutputStream processInput) {
        this.inputHandler.process(processInput, this.getWatchdog());
    }

    public void reset() {
        this.canceled = false;
        this.complete = false;
        this.exception = null;
        this.exitCode = 0;
    }

    public boolean succeeded() {
        return this.exception == null;
    }

    private void fireComplete(StreamHandler<?> handler, CommandSummary summary) {
        try {
            handler.onComplete(summary);
        }
        catch (Exception e) {
            if (this.exception != null) {
                this.exception.addSuppressed((Throwable)e);
            }
            this.exception = e instanceof ProcessException ? (ProcessException)e : new ProcessException((Throwable)e);
        }
    }

    private static interface StreamHandler<S>
    extends CommandSummaryHandler {
        public boolean isSet();

        public void process(S var1, Watchdog var2) throws ProcessException;
    }

    private static interface OutputStreamHandler
    extends StreamHandler<OutputStream> {
        @Override
        public void process(OutputStream var1, Watchdog var2);
    }

    private static interface InputStreamHandler
    extends StreamHandler<InputStream> {
    }

    private static class DelegatingOutputStreamHandler
    extends AbstractStreamHandler<OutputStream, InputHandler>
    implements OutputStreamHandler {
        private DelegatingOutputStreamHandler(InputHandler handler) {
            super(handler);
        }

        public static OutputStreamHandler wrap(InputHandler handler) {
            if (handler == null) {
                return new NullStreamHandler();
            }
            return new DelegatingOutputStreamHandler(handler);
        }

        @Override
        public void process(OutputStream stream, Watchdog watchdog) {
            ((InputHandler)this.handler).setWatchdog(watchdog);
            ((InputHandler)this.handler).process(stream);
        }

        @Override
        protected void complete() {
            ((InputHandler)this.handler).complete();
        }

        private static class NullStreamHandler
        extends AbstractStreamHandler.AbstractNullStreamHandler<OutputStream>
        implements OutputStreamHandler {
            private NullStreamHandler() {
            }
        }
    }

    private static class DelegatingInputStreamHandler
    extends AbstractStreamHandler<InputStream, OutputHandler>
    implements InputStreamHandler {
        private DelegatingInputStreamHandler(OutputHandler handler) {
            super(handler);
        }

        public static InputStreamHandler wrap(OutputHandler handler) {
            if (handler == null) {
                return new NullStreamHandler();
            }
            return new DelegatingInputStreamHandler(handler);
        }

        @Override
        public void process(InputStream stream, Watchdog watchdog) throws ProcessException {
            ((OutputHandler)this.handler).setWatchdog(watchdog);
            ((OutputHandler)this.handler).process(stream);
        }

        @Override
        protected void complete() throws ProcessException {
            ((OutputHandler)this.handler).complete();
        }

        private static class NullStreamHandler
        extends AbstractStreamHandler.AbstractNullStreamHandler<InputStream>
        implements InputStreamHandler {
            private NullStreamHandler() {
            }
        }
    }

    private static abstract class AbstractStreamHandler<S, H>
    implements StreamHandler<S> {
        protected final H handler;

        protected AbstractStreamHandler(H handler) {
            this.handler = handler;
        }

        @Override
        public boolean isSet() {
            return true;
        }

        public void onComplete(@Nonnull CommandSummary summary) throws ProcessException {
            if (this.handler instanceof CommandSummaryHandler) {
                ((CommandSummaryHandler)this.handler).onComplete(summary);
            } else {
                this.complete();
            }
        }

        protected abstract void complete() throws ProcessException;

        protected static abstract class AbstractNullStreamHandler<S>
        implements CommandSummaryHandler {
            protected AbstractNullStreamHandler() {
            }

            public boolean isSet() {
                return false;
            }

            public void onComplete(@Nonnull CommandSummary summary) {
            }

            public void process(S stream, Watchdog watchdog) {
                throw new IllegalStateException("process(...) was called on a handler that was not supplied");
            }
        }
    }
}

