/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.CommandBuilder;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public abstract class AbstractCommandBuilder<B extends CommandBuilder<B>>
implements CommandBuilder<B> {
    protected final LinkedList<String> arguments;
    protected final String binary;
    protected final Map<String, String> environment;
    protected final I18nService i18nService;
    protected CommandExitHandler exitHandler;
    protected CommandInputHandler inputHandler;
    protected CommandErrorHandler errorHandler;
    protected File workingDirectory;

    protected AbstractCommandBuilder(@Nonnull I18nService i18nService, @Nonnull String binary) {
        this(i18nService, binary, null);
    }

    protected AbstractCommandBuilder(@Nonnull I18nService i18nService, @Nonnull String binary, @Nullable File workingDirectory) {
        this.binary = this.notBlank(binary);
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        this.workingDirectory = this.directoryExistsOrIsNull(workingDirectory);
        this.arguments = Lists.newLinkedList();
        this.environment = Maps.newHashMap();
    }

    @Nonnull
    public B argument(@Nonnull String argument) {
        this.arguments.add(this.notBlank(argument));
        return this.self();
    }

    @Nonnull
    public B argumentAfter(@Nonnull String anchor, @Nonnull String argument) {
        int index = this.arguments.indexOf(this.notBlank(anchor, "anchor"));
        if (index == -1) {
            return this.argument(argument);
        }
        return this.argumentAt(index + 1, argument);
    }

    @Nonnull
    public B argumentAt(int index, @Nonnull String argument) {
        this.arguments.add(index, this.notBlank(argument));
        return this.self();
    }

    @Nonnull
    public B argumentBefore(@Nonnull String anchor, @Nonnull String argument) {
        int index = this.arguments.indexOf(this.notBlank(anchor, "anchor"));
        if (index == -1) {
            return this.argument(argument);
        }
        return this.argumentAt(index, argument);
    }

    @Nonnull
    public B clearArguments() {
        this.arguments.clear();
        return this.self();
    }

    @Nonnull
    public B clearEnvironment() {
        this.environment.clear();
        return this.self();
    }

    @Nonnull
    public B clearInputHandler() {
        this.inputHandler = null;
        return this.self();
    }

    @Nonnull
    public B defaultErrorHandler() {
        this.errorHandler = null;
        return this.self();
    }

    @Nonnull
    public B defaultExitHandler() {
        this.exitHandler = null;
        return this.self();
    }

    @Nonnull
    public B defaultWorkingDirectory() {
        this.workingDirectory = null;
        return this.self();
    }

    @Nonnull
    public B errorHandler(@Nonnull CommandErrorHandler value) {
        this.errorHandler = (CommandErrorHandler)Preconditions.checkNotNull((Object)value, (Object)"errorHandler");
        return this.self();
    }

    @Nonnull
    public B exitHandler(@Nonnull CommandExitHandler value) {
        this.exitHandler = (CommandExitHandler)Preconditions.checkNotNull((Object)value, (Object)"exitHandler");
        return this.self();
    }

    @Nonnull
    public B inputHandler(@Nonnull CommandInputHandler value) {
        this.inputHandler = (CommandInputHandler)Preconditions.checkNotNull((Object)value, (Object)"inputHandler");
        return this.self();
    }

    @Nonnull
    public B withEnvironment(@Nonnull String name, @Nonnull String value) {
        this.environment.put(this.notBlank(name, "name"), this.notBlank(value, "value"));
        return this.self();
    }

    @Nonnull
    public B workingDirectory(@Nonnull File value) {
        this.workingDirectory = this.directoryExists(value);
        return this.self();
    }

    @Nonnull
    public B workingDirectory(@Nonnull String value) {
        return this.workingDirectory(new File(value));
    }

    @Nonnull
    protected File directoryExists(@Nonnull File value) {
        return AbstractCommandBuilder.existsAndIsDirectory((File)Preconditions.checkNotNull((Object)value, (Object)"directory"));
    }

    @Nullable
    protected File directoryExistsOrIsNull(@Nullable File value) {
        return value == null ? null : AbstractCommandBuilder.existsAndIsDirectory(value);
    }

    @Nonnull
    protected String notBlank(@Nullable String argument) {
        return this.notBlank(argument, "argument");
    }

    protected String notBlank(@Nullable String value, @Nullable String name) {
        Preconditions.checkNotNull((Object)value, (Object)name);
        value = value.trim();
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (String)"A non-blank %s is required", (Object[])new Object[]{StringUtils.defaultString((String)name, (String)"value")});
        return value;
    }

    protected abstract B self();

    @Nonnull
    private static File existsAndIsDirectory(@Nonnull File value) {
        Preconditions.checkArgument((boolean)value.exists(), (String)"[%s] does not exist", (Object[])new Object[]{value.getAbsolutePath()});
        Preconditions.checkArgument((boolean)value.isDirectory(), (String)"[%s] is not a directory", (Object[])new Object[]{value.getAbsolutePath()});
        return value;
    }
}

