/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.throttle;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.throttle.ResourceBusyException;
import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledScmRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(ThrottledScmRequestFactory.class);
    @VisibleForTesting
    static final String RESOURCE_NAME = "scm-hosting";
    private final ThrottleService throttleService;
    private final I18nService i18nService;
    private final HelpPathService helpPathService;

    public ThrottledScmRequestFactory(ThrottleService throttleService, I18nService i18nService, HelpPathService helpPathService) {
        this.throttleService = (ThrottleService)Preconditions.checkNotNull((Object)throttleService, (Object)"throttleService");
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        this.helpPathService = (HelpPathService)Preconditions.checkNotNull((Object)helpPathService, (Object)"helpPathService");
    }

    @Nonnull
    public SshScmRequest throttled(@Nonnull SshScmRequest request) {
        return this.throttled((ScmRequest)Preconditions.checkNotNull((Object)request, (Object)"request"), SshScmRequest.class);
    }

    @Nonnull
    public HttpScmRequest throttled(@Nonnull HttpScmRequest request) {
        return this.throttled((ScmRequest)Preconditions.checkNotNull((Object)request, (Object)"request"), HttpScmRequest.class);
    }

    private <T extends ScmRequest> T throttled(@Nonnull T request, Class<T> clazz) {
        return (T)((ScmRequest)clazz.cast(Proxy.newProxyInstance(request.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ThrottlingInvocationHandler(request))));
    }

    private class ThrottlingInvocationHandler
    implements InvocationHandler {
        private final ScmRequest target;

        private ThrottlingInvocationHandler(ScmRequest target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (Ticket ticket = null;){
                if ("handleRequest".equals(method.getName())) {
                    try {
                        ticket = ThrottledScmRequestFactory.this.throttleService.acquireTicket(ThrottledScmRequestFactory.RESOURCE_NAME);
                    }
                    catch (ResourceBusyException e) {
                        this.target.sendError(ThrottledScmRequestFactory.this.i18nService.getMessage("bitbucket.scm.throttled", new Object[0]), ThrottledScmRequestFactory.this.i18nService.getMessage("bitbucket.scm.throttled.detail", new Object[]{Product.NAME}));
                        log.info(String.format("A %s request was denied due to heavy server load. Please see %s for performance guidelines.", ThrottledScmRequestFactory.RESOURCE_NAME, ThrottledScmRequestFactory.this.helpPathService.getPageUrl("bitbucket.help.scaling")));
                        Object var6_8 = null;
                        if (ticket != null) {
                            ticket.close();
                        }
                        return var6_8;
                    }
                }
                Object e = method.invoke((Object)this.target, args);
                return e;
            }
        }
    }
}

