/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.scm.pull.RepositoryRescopeContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

public class RepositoryRescopeCommandParameters
extends AbstractCommandParameters {
    private final Iterable<RefChange> refChanges;
    private final Repository repository;
    private final RepositoryRescopeContext rescopeContext;

    private RepositoryRescopeCommandParameters(RepositoryRescopeContext rescopeContext, Repository repository, Iterable<RefChange> refChanges) {
        this.refChanges = refChanges;
        this.repository = repository;
        this.rescopeContext = rescopeContext;
    }

    @Nonnull
    public Iterable<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public RepositoryRescopeContext getRescopeContext() {
        return this.rescopeContext;
    }

    public static class Builder {
        private final ImmutableList.Builder<RefChange> refChanges = ImmutableList.builder();
        private Repository repository;
        private RepositoryRescopeContext rescopeContext;

        public Builder() {
        }

        public Builder(@Nonnull RepositoryRescopeCommandParameters parameters) {
            this();
            this.refChanges.addAll(((RepositoryRescopeCommandParameters)((Object)Preconditions.checkNotNull((Object)((Object)parameters), (Object)"parameters"))).getRefChanges());
            this.repository = parameters.getRepository();
            this.rescopeContext = parameters.getRescopeContext();
        }

        @Nonnull
        public RepositoryRescopeCommandParameters build() {
            Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"The repository for which pull requests should be rescoped is required");
            Preconditions.checkState((this.rescopeContext != null ? 1 : 0) != 0, (Object)"The pull request rescope context is required");
            return new RepositoryRescopeCommandParameters(this.rescopeContext, this.repository, (Iterable)this.refChanges.build());
        }

        @Nonnull
        public Builder refChange(@Nonnull RefChange value) {
            this.refChanges.add((Object)value);
            return this;
        }

        @Nonnull
        public Builder refChanges(@Nonnull Iterable<RefChange> value) {
            this.refChanges.addAll(value);
            return this;
        }

        @Nonnull
        public Builder refChanges(@Nonnull RefChange value, RefChange ... values) {
            this.refChanges.add((Object)value).add((Object[])values);
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)value, (Object)"repository");
            return this;
        }

        @Nonnull
        public Builder rescopeContext(@Nonnull RepositoryRescopeContext value) {
            this.rescopeContext = (RepositoryRescopeContext)Preconditions.checkNotNull((Object)value, (Object)"rescopeContext");
            return this;
        }
    }
}

