/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.SummarizingProcessHandler;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommand<T>
implements Command<T>,
AsyncCommand<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseCommand.class);
    private final List<String> arguments;
    private final Map<String, String> environment;
    private final OutputHandler errorHandler;
    private final CommandExitHandler exitHandler;
    private final InputHandler inputHandler;
    private final OutputHandler outputHandler;
    private final File workingDir;
    private Long executionTimeoutInSeconds;
    private Long idleTimeoutInSeconds;
    private ExternalProcess process;
    private ProcessHandler processHandler;
    private volatile boolean startable;

    protected BaseCommand(String binary, String command, Map<String, String> environment, @Nullable File workingDir, @Nullable CommandExitHandler exitHandler, @Nullable CommandInputHandler inputHandler, @Nullable CommandOutputHandler<T> outputHandler, @Nullable CommandErrorHandler errorHandler) {
        this.environment = environment;
        this.errorHandler = (OutputHandler)MoreObjects.firstNonNull((Object)errorHandler, (Object)new StringOutputHandler("UTF-8"));
        this.exitHandler = exitHandler;
        this.inputHandler = inputHandler;
        this.outputHandler = (OutputHandler)MoreObjects.firstNonNull(outputHandler, (Object)new StringOutputHandler("UTF-8"));
        this.workingDir = workingDir;
        this.arguments = Lists.newArrayList((Object[])new String[]{binary});
        if (StringUtils.isNotBlank((CharSequence)command)) {
            this.arguments.add(command);
        }
        this.startable = true;
    }

    @Nonnull
    public AsyncCommand<T> asynchronous() {
        return this;
    }

    @Nullable
    public T call() {
        Future<T> result = this.doStart(false);
        try {
            return result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.callExitHandler();
            return null;
        }
    }

    public void setExecutionTimeout(long timeoutInSecs) {
        this.executionTimeoutInSeconds = timeoutInSecs;
    }

    public void setIdleTimeout(long timeoutInSecs) {
        this.idleTimeoutInSeconds = timeoutInSecs;
    }

    @Nonnull
    public Future<T> start() {
        if (!this.startable) {
            throw new IllegalStateException("This AsyncCommand has been converted to synchronous. It may no longer be started asynchronously.");
        }
        return this.doStart(true);
    }

    @Nonnull
    public Command<T> synchronous() {
        this.startable = false;
        return this;
    }

    @Nonnull
    public String toString() {
        return StringUtils.join(this.arguments, (String)" ");
    }

    protected void addArgument(Object ... options) {
        for (Object option : options) {
            this.arguments.add(String.valueOf(option));
        }
    }

    protected void callExitHandler() {
        if (this.exitHandler != null) {
            String command = this.toString();
            String stdErr = null;
            if (this.errorHandler instanceof StringOutputHandler) {
                stdErr = StringUtils.chomp((String)((StringOutputHandler)this.errorHandler).getOutput());
            }
            if (this.process.isCanceled()) {
                log.trace("The process was canceled");
                this.exitHandler.onCancel(command, this.processHandler.getExitCode(), stdErr, (Throwable)this.processHandler.getException());
            } else {
                log.trace("The process completed with exit code {} and stderr of:\n{}", (Object)this.processHandler.getExitCode(), (Object)stdErr);
                this.exitHandler.onExit(command, this.processHandler.getExitCode(), stdErr, (Throwable)this.processHandler.getException());
            }
        }
    }

    @Nonnull
    protected OutputHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Nullable
    protected InputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Nonnull
    protected OutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    @Nonnull
    protected ProcessHandler getProcessHandler() {
        if (this.processHandler == null) {
            this.processHandler = new SummarizingProcessHandler(this.getInputHandler(), this.getOutputHandler(), this.getErrorHandler());
        }
        return this.processHandler;
    }

    @Nullable
    protected abstract T getResult();

    private Future<T> doStart(boolean asynchronous) {
        if (log.isTraceEnabled()) {
            log.trace("Starting {} ", (Object)this.toString());
        }
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder().command((List)ImmutableList.copyOf(this.arguments), this.workingDir).env(this.environment).handler(this.getProcessHandler());
        if (asynchronous) {
            processBuilder.asynchronous();
        }
        if (this.executionTimeoutInSeconds != null) {
            processBuilder.executionTimeout(TimeUnit.SECONDS.toMillis(this.executionTimeoutInSeconds));
        }
        if (this.idleTimeoutInSeconds != null) {
            processBuilder.idleTimeout(TimeUnit.SECONDS.toMillis(this.idleTimeoutInSeconds));
        }
        this.process = processBuilder.build();
        this.process.start();
        return new CommandFuture();
    }

    private class CommandFuture
    implements Future<T> {
        private volatile boolean done;
        private T result;

        @Override
        public boolean cancel(boolean interruptAllowed) {
            if (BaseCommand.this.process.getHandler().isComplete() || this.isCancelled()) {
                return false;
            }
            log.debug("Canceling process '{}'", (Object)BaseCommand.this.process.getCommandLine());
            BaseCommand.this.process.cancel();
            return BaseCommand.this.process.finish(100);
        }

        @Override
        public T get() {
            if (this.done) {
                return this.result;
            }
            BaseCommand.this.process.finish();
            return this.internalGet();
        }

        @Override
        public T get(long l, @Nonnull TimeUnit timeUnit) throws TimeoutException {
            if (this.done) {
                return this.result;
            }
            int timeoutMs = (int)timeUnit.toMillis(l);
            if (!BaseCommand.this.process.finish(timeoutMs)) {
                throw new TimeoutException("Timed out while waiting for " + BaseCommand.this.process.getCommandLine() + " to finish");
            }
            return this.internalGet();
        }

        @Override
        public boolean isCancelled() {
            return BaseCommand.this.process.isCanceled();
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        private T internalGet() {
            if (!this.done) {
                this.done = true;
                log.debug("Executed {}", (Object)BaseCommand.this);
                BaseCommand.this.callExitHandler();
                this.result = BaseCommand.this.getResult();
            }
            return this.result;
        }
    }
}

