/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.attribute.UserPrincipalNotFoundException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.SystemUtils;

public class FilePermissionUtils {
    @VisibleForTesting
    static final Set<AclEntryPermission> ACL_ENTRY_PERMISSIONS = Sets.immutableEnumSet(EnumSet.complementOf(EnumSet.of(AclEntryPermission.EXECUTE)));

    public static void setRestrictedFilePermissions(@Nonnull File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"exists");
        if (SystemUtils.IS_OS_WINDOWS) {
            LinkedList<UserPrincipal> userPrincipals = new LinkedList<UserPrincipal>();
            UserPrincipalLookupService principalService = file.toPath().getFileSystem().getUserPrincipalLookupService();
            userPrincipals.add(principalService.lookupPrincipalByName(System.getProperty("user.name")));
            try {
                userPrincipals.add(principalService.lookupPrincipalByGroupName("Administrators"));
            }
            catch (UserPrincipalNotFoundException userPrincipalNotFoundException) {
                // empty catch block
            }
            AclFileAttributeView view = Files.getFileAttributeView(file.toPath(), AclFileAttributeView.class, new LinkOption[0]);
            view.setAcl(FilePermissionUtils.createAclEntries(userPrincipals));
        } else {
            try {
                Files.setPosixFilePermissions(file.toPath(), Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ, PosixFilePermission.GROUP_READ}));
            }
            catch (UnsupportedOperationException e) {
                throw new IOException("Could not set permissions on file " + file.getAbsolutePath(), e);
            }
        }
    }

    private static List<AclEntry> createAclEntries(List<UserPrincipal> principals) throws IOException {
        LinkedList<AclEntry> acls = new LinkedList<AclEntry>();
        for (UserPrincipal principal : principals) {
            acls.add(FilePermissionUtils.createAclEntry(principal));
        }
        return acls;
    }

    private static AclEntry createAclEntry(UserPrincipal user) throws IOException {
        AclEntry.Builder aclEntry = AclEntry.newBuilder();
        aclEntry.setPermissions(ACL_ENTRY_PERMISSIONS);
        aclEntry.setPrincipal(user);
        aclEntry.setType(AclEntryType.ALLOW);
        return aclEntry.build();
    }
}

