/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.DateFormatter;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.util.InternalDateFormatter;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DateFormatter.class)
@Component(value="dateFormatter")
public class DefaultDateFormatter
implements InternalDateFormatter {
    private static final Duration FIVE_HOURS = Duration.ofHours(5L);
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDateFormatter.class);
    private final Properties dateFormatProperties;
    private final I18nService i18nService;
    private final Map<DateFormatter.FormatType, DateTimeFormatter> formatters;
    private final InternalLocaleService localeService;
    private final Supplier<Instant> nowSupplier;
    private final ZoneId serverTz;
    private final String stateHash;

    @Autowired
    public DefaultDateFormatter(I18nService i18nService, InternalApplicationPropertiesService applicationPropertiesService, @Value(value="#{dateFormatProperties}") Properties dateFormatProperties, InternalLocaleService localeService) {
        this(i18nService, applicationPropertiesService, dateFormatProperties, localeService, Instant::now);
    }

    @VisibleForTesting
    DefaultDateFormatter(I18nService i18nService, InternalApplicationPropertiesService applicationPropertiesService, Properties dateFormatProperties, InternalLocaleService localeService, Supplier<Instant> nowSupplier) {
        this.dateFormatProperties = dateFormatProperties;
        this.i18nService = i18nService;
        this.localeService = localeService;
        this.nowSupplier = nowSupplier;
        this.serverTz = applicationPropertiesService.getDefaultTimeZone().toZoneId();
        this.formatters = DefaultDateFormatter.generateFormatters(dateFormatProperties, this.serverTz, applicationPropertiesService.getLocale());
        this.stateHash = DefaultDateFormatter.calculateState(dateFormatProperties);
    }

    public String getStateHash() {
        return this.stateHash;
    }

    @Nonnull
    public String formatDate(@Nonnull Date date, @Nonnull DateFormatter.FormatType type) {
        Objects.requireNonNull(date, "date");
        return this.formatInstant(date.toInstant(), type);
    }

    @Nonnull
    public String formatInstant(@Nonnull Instant instant, @Nonnull DateFormatter.FormatType type) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(type, "type");
        if (type.isAge()) {
            return this.formatInstantWithRelativeAge(instant, type);
        }
        return this.formatInstantWithFormatString(instant, type);
    }

    public String getFormatString(String key) {
        return this.dateFormatProperties.getProperty(key);
    }

    private static String calculateState(Properties properties) {
        HashBuilder builder = new HashBuilder();
        for (String propertyName : properties.stringPropertyNames()) {
            builder.add(propertyName + StringUtils.stripToEmpty((String)properties.getProperty(propertyName)));
        }
        return builder.build();
    }

    private static Map<DateFormatter.FormatType, DateTimeFormatter> generateFormatters(Properties properties, ZoneId tz, Locale locale) {
        EnumMap<DateFormatter.FormatType, DateTimeFormatter> formatterMap = new EnumMap<DateFormatter.FormatType, DateTimeFormatter>(DateFormatter.FormatType.class);
        for (DateFormatter.FormatType formatType : DateFormatter.FormatType.values()) {
            formatterMap.computeIfAbsent(DefaultDateFormatter.toActualType(formatType), type -> {
                DateTimeFormatter formatter;
                String pattern = StringUtils.stripToNull((String)properties.getProperty(type.getKey()));
                if (pattern == null) {
                    LOG.warn("Date pattern not found for '{}'. Using a default pattern.", (Object)type.getKey());
                    formatter = DateTimeFormatter.ISO_DATE_TIME;
                } else {
                    try {
                        formatter = DateTimeFormatter.ofPattern(pattern);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Date pattern '{}' in '{}' is not valid. Using a default pattern.", new Object[]{pattern, type.getKey(), e});
                        formatter = DateTimeFormatter.ISO_DATE_TIME;
                    }
                }
                return formatter.withLocale(locale).withZone(tz);
            });
        }
        return Collections.unmodifiableMap(formatterMap);
    }

    private static DateFormatter.FormatType toActualType(DateFormatter.FormatType type) {
        if (type == DateFormatter.FormatType.SHORTAGE) {
            return DateFormatter.FormatType.SHORT;
        }
        if (type == DateFormatter.FormatType.LONGAGE) {
            return DateFormatter.FormatType.LONG;
        }
        return type;
    }

    private String formatInstantWithFormatString(Instant instant, DateFormatter.FormatType type) {
        return this.formatters.get(DefaultDateFormatter.toActualType(type)).withLocale(this.localeService.getLocale()).format(instant);
    }

    private String formatInstantWithRelativeAge(Instant instant, DateFormatter.FormatType type) {
        return this.formatInstantWithRelativeAge(this.nowSupplier.get(), instant, type);
    }

    private String formatInstantWithRelativeAge(Instant now, Instant time, DateFormatter.FormatType type) {
        Duration diff = Duration.between(time, now);
        if (diff.isNegative()) {
            return this.formatInstantWithFormatString(time, type);
        }
        long minutes = diff.toMinutes();
        if (minutes < 1L) {
            return this.i18nService.getMessage(type.getKey() + ".a.moment.ago", new Object[0]);
        }
        if (minutes < 2L) {
            return this.i18nService.getMessage(type.getKey() + ".one.minute.ago", new Object[0]);
        }
        if (minutes < 50L) {
            return this.i18nService.getMessage(type.getKey() + ".x.minutes.ago", new Object[]{minutes});
        }
        if (minutes < 90L) {
            return this.i18nService.getMessage(type.getKey() + ".one.hour.ago", new Object[0]);
        }
        long days = diff.toDays();
        if (days < 1L) {
            if (diff.compareTo(FIVE_HOURS) > 0 && this.isYesterday(now, time)) {
                return this.i18nService.getMessage(type.getKey() + ".one.day.ago", new Object[0]);
            }
            long roundUpHours = diff.plusMinutes(30L).toHours();
            return this.i18nService.getMessage(type.getKey() + ".x.hours.ago", new Object[]{roundUpHours});
        }
        if (days < 7L) {
            if (days < 2L && this.isYesterday(now, time)) {
                return this.i18nService.getMessage(type.getKey() + ".one.day.ago", new Object[0]);
            }
            return this.i18nService.getMessage(type.getKey() + ".x.days.ago", new Object[]{Math.max(days, 2L)});
        }
        if (days < 8L) {
            return this.i18nService.getMessage(type.getKey() + ".one.week.ago", new Object[0]);
        }
        return this.formatInstantWithFormatString(time, type);
    }

    private boolean isYesterday(Instant now, Instant date) {
        ZonedDateTime todayStart = this.zonedDateTimeFrom(now).with(LocalTime.MIDNIGHT);
        ZonedDateTime zonedDate = this.zonedDateTimeFrom(date);
        return zonedDate.isBefore(todayStart) && !zonedDate.isBefore(todayStart.minusDays(1L));
    }

    private ZonedDateTime zonedDateTimeFrom(Instant instant) {
        return ZonedDateTime.ofInstant(instant, this.serverTz);
    }
}

