/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.throttle;

import com.atlassian.bitbucket.NoSuchResourceException;
import com.atlassian.bitbucket.event.throttle.TicketAcquiredEvent;
import com.atlassian.bitbucket.event.throttle.TicketRejectedEvent;
import com.atlassian.bitbucket.event.throttle.TicketReleasedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.throttle.ResourceBusyException;
import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import com.atlassian.bitbucket.throttle.TicketContext;
import com.atlassian.bitbucket.util.PropertiesUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.throttle.AbstractTicket;
import com.atlassian.stash.internal.throttle.InternalThrottleService;
import com.atlassian.stash.internal.throttle.SemaphoreTicketBucket;
import com.atlassian.stash.internal.throttle.TicketSummary;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ThrottleService.class)
@Service(value="throttleService")
public class SemaphoreThrottleService
implements InternalThrottleService,
StatefulService {
    public static final String RESOURCE_PREFIX = "throttle.resource.";
    private static final Maps.EntryTransformer<String, SemaphoreTicketBucket, TicketSummary> TO_SUMMARY = new Maps.EntryTransformer<String, SemaphoreTicketBucket, TicketSummary>(){

        public TicketSummary transformEntry(String name, SemaphoreTicketBucket bucket) {
            return bucket.summarize(name);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(SemaphoreThrottleService.class);
    private final Map<String, SemaphoreTicketBucket> buckets;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final Properties properties;
    private final RequestContext requestContext;
    private final ThreadLocal<CountedTicket> tickets;

    @Autowired
    public SemaphoreThrottleService(EventPublisher eventPublisher, I18nService i18nService, @Qualifier(value="applicationProperties") Properties properties, RequestContext requestContext) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.properties = properties;
        this.requestContext = requestContext;
        this.buckets = Maps.newTreeMap();
        this.tickets = new ThreadLocal();
    }

    @Nonnull
    public Ticket acquireTicket(@Nonnull String resourceName) {
        CountedTicket ticket = this.tickets.get();
        if (ticket == null) {
            SemaphoreTicketBucket bucket = this.getBucket(resourceName);
            if (bucket.tryAcquire()) {
                SimpleTicketContext context = new SimpleTicketContext(resourceName);
                log.trace("Acquired [{}] ticket ({})", (Object)resourceName, (Object)bucket);
                ticket = new SemaphoreTicket(resourceName, context);
                this.eventPublisher.publish((Object)new TicketAcquiredEvent((Object)this, (TicketContext)context));
                this.tickets.set(ticket);
                if (this.requestContext.isActive()) {
                    this.requestContext.addCleanupCallback((Runnable)new ReleaseTickets());
                }
            } else {
                log.warn("A [{}] ticket could not be acquired ({})", (Object)resourceName, (Object)bucket);
                this.eventPublisher.publish((Object)new TicketRejectedEvent((Object)this, resourceName));
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.resource.busy", new Object[0]);
                throw new ResourceBusyException(message, resourceName);
            }
        }
        ticket.acquire();
        return ticket;
    }

    public void cleanupTickets() {
        CountedTicket ticket = this.tickets.get();
        if (ticket != null) {
            ticket.closeNow();
        }
        this.tickets.remove();
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new TicketState(this.tickets.get());
    }

    public TicketSummary[] getSummaries() {
        return (TicketSummary[])Iterables.toArray(Maps.transformEntries(this.buckets, TO_SUMMARY).values(), TicketSummary.class);
    }

    public TicketSummary getSummary(String name) {
        return this.buckets.get(name).summarize(name);
    }

    public long getTimeSinceLastRejectedTicketRequest(String resourceName) {
        long lastRejectedTimestamp = this.getBucket(resourceName).getLastRejectedTimestamp();
        return lastRejectedTimestamp == 0L ? 0L : System.currentTimeMillis() - lastRejectedTimestamp;
    }

    public long getLongestQueueingTimeForCurrentTicketRequests(String resourceName) {
        long earliestQueuingTime = this.getBucket(resourceName).getEarliestQueuingTime();
        return earliestQueuingTime == 0L ? 0L : System.currentTimeMillis() - earliestQueuingTime;
    }

    @PostConstruct
    public void initialise() {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String propertyName = (String)names.nextElement();
            if (!propertyName.startsWith(RESOURCE_PREFIX) || propertyName.endsWith(".timeout")) continue;
            String bucketName = propertyName.substring(RESOURCE_PREFIX.length());
            int tickets = this.parseBucketLimit(bucketName, this.properties.getProperty(propertyName));
            int timeoutSeconds = Integer.parseInt(this.properties.getProperty(propertyName + ".timeout", "0"));
            log.debug("Configured resource [{}] with {} tickets and an acquire timeout of {}s", new Object[]{bucketName, tickets, timeoutSeconds});
            this.buckets.put(bucketName, new SemaphoreTicketBucket(tickets, timeoutSeconds, TimeUnit.SECONDS));
        }
    }

    protected SemaphoreTicketBucket getBucket(String resourceName) {
        SemaphoreTicketBucket ticketBucket = this.buckets.get(resourceName);
        if (ticketBucket == null) {
            throw this.noSuchResource(resourceName, true);
        }
        return ticketBucket;
    }

    private NoSuchResourceException noSuchResource(String resourceName, boolean logThrowing) {
        KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.resource.not.configured", new Object[]{resourceName});
        if (logThrowing) {
            log.error(message.getRootMessage());
        }
        return new NoSuchResourceException(message, resourceName);
    }

    private int parseBucketLimit(String resourceName, String expression) {
        int result = PropertiesUtils.parseExpression((String)expression, (int)-1);
        if (result == -1) {
            result = (int)Math.round((double)Runtime.getRuntime().availableProcessors() * 1.5);
            log.warn("The configured ticket limit for [{}] '{}' is invalid. Only (floating point) numbers, +, -, /, *, (, ) and cpu are supported. Falling back to defaultValue: {}", new Object[]{resourceName, expression, result});
        }
        return result;
    }

    int getNumberOfPermits(String resourceName) {
        return this.getBucket(resourceName).getTotalTickets();
    }

    private final class TicketState
    implements TransferableState {
        private final StubTicket state;

        public TicketState(CountedTicket ticket) {
            if (ticket == null) {
                this.state = null;
            } else {
                this.state = new StubTicket(ticket);
                this.state.acquire();
            }
        }

        public void apply() {
            SemaphoreThrottleService.this.tickets.set(this.state);
        }

        public void remove() {
            SemaphoreThrottleService.this.cleanupTickets();
        }
    }

    @NotThreadSafe
    private class StubTicket
    extends CountedTicket {
        private StubTicket(CountedTicket ticket) {
            super(ticket.getResourceName());
        }
    }

    private static class SimpleTicketContext
    implements TicketContext {
        private final Queue<Runnable> callbacks;
        private final String resourceName;
        private volatile boolean released;

        public SimpleTicketContext(String resourceName) {
            this.resourceName = resourceName;
            this.callbacks = new ArrayDeque<Runnable>();
        }

        public void addReleaseCallback(@Nonnull Runnable callback) {
            if (this.released) {
                this.runCallback(callback);
            } else {
                this.callbacks.offer(Objects.requireNonNull(callback, "callback"));
            }
        }

        @Nonnull
        public String getResourceName() {
            return this.resourceName;
        }

        public void onRelease() {
            Runnable callback;
            this.released = true;
            while ((callback = this.callbacks.poll()) != null) {
                this.runCallback(callback);
            }
        }

        private void runCallback(Runnable callback) {
            try {
                callback.run();
            }
            catch (Exception e) {
                log.warn("Ticket release callback failed", (Throwable)e);
            }
        }
    }

    @NotThreadSafe
    private final class SemaphoreTicket
    extends CountedTicket {
        private final SimpleTicketContext context;

        private SemaphoreTicket(String resourceName, SimpleTicketContext context) {
            super(resourceName);
            this.context = context;
        }

        @Override
        protected void onRelease() {
            super.onRelease();
            SemaphoreTicketBucket bucket = (SemaphoreTicketBucket)SemaphoreThrottleService.this.buckets.get(this.resourceName);
            bucket.release();
            log.trace("Released [{}] ticket ({})", (Object)this.resourceName, (Object)bucket);
            SemaphoreThrottleService.this.eventPublisher.publish((Object)new TicketReleasedEvent((Object)SemaphoreThrottleService.this, this.resourceName));
            this.context.onRelease();
        }

        @Override
        protected void onRetain(int count) {
            log.trace("Not releasing [{}] ticket ({} acquire(s) remain)", (Object)this.resourceName, (Object)count);
        }
    }

    private class ReleaseTickets
    implements Runnable {
        private ReleaseTickets() {
        }

        @Override
        public void run() {
            SemaphoreThrottleService.this.cleanupTickets();
        }
    }

    @NotThreadSafe
    private class CountedTicket
    extends AbstractTicket {
        private final AtomicInteger count;

        private CountedTicket(String resourceName) {
            super(resourceName);
            this.count = new AtomicInteger(0);
        }

        public void acquire() {
            this.count.incrementAndGet();
        }

        public void close() {
            this.closeIf(new Predicate<Ticket>(){

                public boolean apply(Ticket input) {
                    return CountedTicket.this.count.decrementAndGet() == 0;
                }
            });
        }

        protected void onRelease() {
            SemaphoreThrottleService.this.tickets.remove();
        }

        protected void onRetain(int count) {
        }

        private void closeIf(Predicate<Ticket> predicate) {
            Ticket removed = (Ticket)SemaphoreThrottleService.this.tickets.get();
            if (removed == this) {
                if (predicate.apply((Object)removed)) {
                    this.onRelease();
                } else {
                    this.onRetain(this.count.get());
                }
            } else {
                throw new IllegalStateException("Attempted to release a [" + this.resourceName + "] ticket on a thread which did not own it");
            }
        }

        private void closeNow() {
            this.closeIf((Predicate<Ticket>)Predicates.alwaysTrue());
        }
    }
}

