/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.stash.internal.task.InternalTask;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.task.TaskPostProcessor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class CompositeTaskPostProcessor
implements TaskPostProcessor {
    private final List<TaskPostProcessor> postProcessors;

    public CompositeTaskPostProcessor(List<TaskPostProcessor> postProcessors) {
        this.postProcessors = ImmutableList.copyOf(postProcessors);
    }

    @Override
    @Nonnull
    public InternalTask process(InternalTask task) {
        for (TaskPostProcessor postProcessor : this.postProcessors) {
            task = postProcessor.process(task);
        }
        return task;
    }

    @Override
    @Nonnull
    public Iterable<InternalTask> processAll(InternalTaskContext context, Iterable<InternalTask> tasks) {
        for (TaskPostProcessor postProcessor : this.postProcessors) {
            tasks = postProcessor.processAll(context, tasks);
        }
        return tasks;
    }
}

