/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserResolutionException;
import com.atlassian.stash.internal.sal.user.DefaultUserProfile;
import com.atlassian.stash.internal.user.InternalUserService;
import java.security.Principal;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=UserManager.class)
@Component(value="userManager")
public class DefaultUserManager
implements UserManager {
    private final AvatarService avatarService;
    private final AuthenticationContext authenticationContext;
    private final NavBuilder navBuilder;
    private final PermissionService permissionService;
    private final InternalUserService userService;

    @Autowired
    public DefaultUserManager(AvatarService avatarService, AuthenticationContext authenticationContext, NavBuilder navBuilder, PermissionService permissionService, InternalUserService userService) {
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.navBuilder = navBuilder;
        this.permissionService = permissionService;
        this.userService = userService;
    }

    public boolean authenticate(String username, String password) {
        try {
            this.userService.authenticate(username, password);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
        catch (NoSuchUserException e) {
            return false;
        }
    }

    public Iterable<String> findGroupNamesByPrefix(String prefix, int startIndex, int maxResults) {
        return this.userService.findGroupsByPrefix(prefix, PageUtils.newRequest((int)startIndex, (int)maxResults)).getValues();
    }

    @Nullable
    public UserProfile getRemoteUser() {
        return this.fromUser(this.authenticationContext.getCurrentUser());
    }

    public String getRemoteUsername() {
        return this.authenticationContext.isAuthenticated() ? this.authenticationContext.getCurrentUser().getName() : null;
    }

    @Nullable
    public UserKey getRemoteUserKey() {
        return this.authenticationContext.isAuthenticated() ? DefaultUserManager.getUserKey(this.authenticationContext.getCurrentUser()) : null;
    }

    public String getRemoteUsername(HttpServletRequest request) {
        return this.getRemoteUsername();
    }

    @Nullable
    public UserProfile getRemoteUser(HttpServletRequest request) {
        return this.getRemoteUser();
    }

    @Nullable
    public UserKey getRemoteUserKey(HttpServletRequest request) {
        return this.getRemoteUserKey();
    }

    public UserProfile getUserProfile(String username) {
        return StringUtils.isNotEmpty((CharSequence)username) ? this.fromUser(this.userService.getUserByName(username)) : null;
    }

    @Nullable
    public UserProfile getUserProfile(UserKey userKey) {
        ApplicationUser user = this.getUserByKey(userKey);
        return userKey != null ? this.fromUser(user) : null;
    }

    public boolean isAdmin(String username) {
        return StringUtils.isNotEmpty((CharSequence)username) && this.hasGlobalPermission(username, Permission.ADMIN);
    }

    public boolean isAdmin(UserKey userKey) {
        ApplicationUser user = this.getUserByKey(userKey);
        return user != null && this.hasGlobalPermission(user, Permission.ADMIN);
    }

    public boolean isSystemAdmin(String username) {
        return StringUtils.isNotEmpty((CharSequence)username) && this.hasGlobalPermission(username, Permission.SYS_ADMIN);
    }

    public boolean isSystemAdmin(UserKey userKey) {
        return userKey != null && this.hasGlobalPermission(this.getUserByKey(userKey), Permission.SYS_ADMIN);
    }

    public boolean isUserInGroup(String username, String group) {
        return StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)group) && this.userService.isUserInGroup(username, group);
    }

    public boolean isUserInGroup(UserKey userKey, String group) {
        if (userKey == null || StringUtils.isEmpty((CharSequence)group)) {
            return false;
        }
        ApplicationUser user = this.getUserByKey(userKey);
        return user != null && this.userService.isUserInGroup(user, group);
    }

    public Principal resolve(String username) throws UserResolutionException {
        try {
            return this.userService.getUserByName(username);
        }
        catch (Exception e) {
            throw new UserResolutionException((Throwable)e);
        }
    }

    private UserProfile fromUser(ApplicationUser user) {
        return user == null ? null : new DefaultUserProfile(user, this.navBuilder, this.avatarService);
    }

    private boolean hasGlobalPermission(String username, Permission permission) {
        return username != null && this.permissionService.hasGlobalPermission(username, permission);
    }

    private boolean hasGlobalPermission(ApplicationUser user, Permission permission) {
        return user != null && this.permissionService.hasGlobalPermission(user, permission);
    }

    private ApplicationUser getUserByKey(UserKey userKey) {
        block5: {
            if (userKey == null) {
                return null;
            }
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            if (currentUser != null) {
                try {
                    int id = currentUser.getId();
                    if (id == Integer.parseInt(userKey.getStringValue())) {
                        return currentUser;
                    }
                }
                catch (NumberFormatException e) {
                    if (!currentUser.getName().equals(userKey.getStringValue())) break block5;
                    return currentUser;
                }
            }
        }
        return this.userService.getUserByKey(userKey);
    }

    private static UserKey getUserKey(ApplicationUser stashUser) {
        return UserKey.fromLong((long)stashUser.getId());
    }
}

