/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitEnricher;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.SimpleRescopeDetails;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.atlassian.stash.internal.pull.PullRequestActivityEnricher;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import com.atlassian.stash.internal.pull.rescope.RescopeProcessor;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RescopePullRequestActivityEnricher
implements PullRequestActivityEnricher {
    private final CommitEnricher commitEnricher;
    private final RescopeProcessor rescopeProcessor;
    private final ScmService scmService;

    @Autowired
    public RescopePullRequestActivityEnricher(CommitEnricher commitEnricher, RescopeProcessor rescopeProcessor, ScmService scmService) {
        this.commitEnricher = commitEnricher;
        this.rescopeProcessor = rescopeProcessor;
        this.scmService = scmService;
    }

    @Override
    public void enrich(@Nonnull InternalPullRequest pullRequest, @Nonnull Iterable<InternalPullRequestActivity> activities) {
        String timerName = "Enrich: Rescopes from " + pullRequest.getGlobalId() + " (" + Iterables.size(activities) + ")";
        try (Timer ignored = TimerUtils.start((String)timerName);){
            WinnowingVisitor visitor = new WinnowingVisitor();
            for (InternalPullRequestActivity activity : activities) {
                activity.accept((PullRequestActivityVisitor)visitor);
            }
            List<InternalPullRequestRescopeActivity> rescopes = visitor.getActivities();
            if (!rescopes.isEmpty()) {
                this.rescopeProcessor.processAll(pullRequest, rescopes);
                this.applyCommits(pullRequest, rescopes);
            }
        }
    }

    private void applyCommits(InternalPullRequest pullRequest, List<InternalPullRequestRescopeActivity> all) {
        Collection activities = Collections2.filter(all, InternalPullRequestRescopeActivity::isPrecalculated);
        Set commitIds = Chainable.chain((Iterable)activities).flatMap((Function)new Function<InternalPullRequestRescopeActivity, Iterable<String>>(){

            @Override
            public Iterable<String> apply(InternalPullRequestRescopeActivity activity) {
                return Iterables.transform((Iterable)activity.getCommits(), InternalPullRequestRescopeCommit::getCommitId);
            }
        }).toSet();
        if (commitIds.isEmpty()) {
            return;
        }
        Iterable<Commit> commits = this.loadCommits(pullRequest, commitIds);
        ImmutableMap commitsById = Maps.uniqueIndex(commits, MinimalCommit::getId);
        for (InternalPullRequestRescopeActivity activity : activities) {
            SimpleRescopeDetails.Builder added = new SimpleRescopeDetails.Builder().total(activity.getTotalAdded());
            SimpleRescopeDetails.Builder removed = new SimpleRescopeDetails.Builder().total(activity.getTotalRemoved());
            for (InternalPullRequestRescopeCommit rescopeCommit : activity.getCommits()) {
                Commit commit = (Commit)commitsById.get(rescopeCommit.getCommitId());
                if (commit == null) continue;
                if (rescopeCommit.getAction() == PullRequestRescopeCommitAction.ADDED) {
                    added.commit(commit);
                    continue;
                }
                removed.commit(commit);
            }
            activity.setAdded(added.build());
            activity.setRemoved(removed.build());
        }
    }

    private Iterable<Commit> loadCommits(InternalPullRequest pullRequest, Set<String> commitIds) {
        final ArrayList commits = Lists.newArrayListWithCapacity((int)commitIds.size());
        this.scmService.getCommandFactory((Repository)pullRequest.getScopeRepository()).commits(new CommitsCommandParameters.Builder().include(commitIds).secondaryRepository((Repository)pullRequest.getFromRef().getRepository()).traverse(false).build(), (CommitCallback)new AbstractCommitCallback(){

            public boolean onCommit(@Nonnull Commit commit) {
                commits.add(commit);
                return true;
            }
        }).call();
        return this.commitEnricher.enrichAll((Repository)pullRequest.getScopeRepository(), (Iterable)commits, null);
    }

    private static class WinnowingVisitor
    extends AbstractPullRequestActivityVisitor {
        private final ImmutableList.Builder<InternalPullRequestRescopeActivity> builder = ImmutableList.builder();

        private WinnowingVisitor() {
        }

        public List<InternalPullRequestRescopeActivity> getActivities() {
            return this.builder.build();
        }

        public void visit(@Nonnull PullRequestRescopeActivity activity) {
            this.builder.add((Object)((InternalPullRequestRescopeActivity)activity));
        }
    }
}

