/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.pull.MinimalPullRequest;
import com.atlassian.bitbucket.scm.pull.RepositoryRescopeCommandParameters;
import com.atlassian.bitbucket.scm.pull.RepositoryRescopeContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.entity.InternalAbstractEntity;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.pull.rescope.DefaultPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class LegacyPullRequestRescopeService
implements InternalPullRequestRescopeService {
    public static final int MAX_RESCOPE_ATTEMPTS = 3;
    private static final Function<PullRequest, MinimalPullRequest> MINIMIZER = new Function<PullRequest, MinimalPullRequest>(){

        public SimpleMinimalPullRequest apply(PullRequest pullRequest) {
            return new SimpleMinimalPullRequest(pullRequest);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestRescopeService.class);
    private final RescopeUpdateStrategy decline = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            LegacyPullRequestRescopeService.this.pullRequestService.decline(pullRequest.globalId, pullRequest.version);
        }

        @Override
        public String getErrorFormat() {
            return "Could not decline pull request %1$s";
        }
    };
    private final RescopeUpdateStrategy merge = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            LegacyPullRequestRescopeService.this.pullRequestService.closeMerged(pullRequest.globalId, pullRequest.version);
        }

        @Override
        public String getErrorFormat() {
            return "Could not mark pull request %1$s as merged";
        }
    };
    private final RescopeUpdateStrategy rescope = new RescopeUpdateStrategy(){

        @Override
        public void apply(SimpleMinimalPullRequest pullRequest) {
            LegacyPullRequestRescopeService.this.pullRequestService.updateScope(pullRequest.globalId, pullRequest.version, pullRequest.newFromHash, pullRequest.newToHash);
        }

        @Override
        public String getErrorFormat() {
            return "Could not rescope pull request %1$s";
        }
    };
    private final AuthenticationContext authenticationContext;
    private final RescopeRequestDao dao;
    private final InternalPullRequestService pullRequestService;
    private final InternalScmService scmService;
    private final SecurityService securityService;

    public LegacyPullRequestRescopeService(AuthenticationContext authenticationContext, RescopeRequestDao dao, InternalPullRequestService pullRequestService, InternalScmService scmService, SecurityService securityService) {
        this.authenticationContext = authenticationContext;
        this.dao = dao;
        this.pullRequestService = pullRequestService;
        this.scmService = scmService;
        this.securityService = securityService;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void createRequest(@Nonnull InternalRepository repository, @Nonnull InternalApplicationUser user, @Nonnull Collection<RefChange> changes) {
        this.dao.create((Object)new InternalRescopeRequest.Builder(repository, user).changes(changes).build());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional
    public RepositoryRescopeResult rescope(@Nonnull Repository repository, @Nonnull List<String> branches) {
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
        InternalRepository repo = InternalConverter.convertToInternalRepository((Repository)repository);
        List changes = branches.stream().map(MarkerRefChange::new).collect(Collectors.toList());
        this.dao.create((Object)new InternalRescopeRequest.Builder(repo, user).changes(changes).build());
        return this.rescope(repository);
    }

    @Nonnull
    @Transactional
    public RepositoryRescopeResult rescope(final @Nonnull Repository repository) {
        final List requests = this.dao.findByRepository(repository.getId());
        if (requests.isEmpty()) {
            log.debug("{}: All rescope requests have already been processed", (Object)repository);
        }
        final Map<String, InternalApplicationUser> branchesToUsers = this.mapBranchesToUsers(requests);
        try (Timer ignored = TimerUtils.start((String)("Rescoping pull requests for " + repository.toString()));){
            RepositoryRescopeResult result = (RepositoryRescopeResult)this.securityService.withPermission(Permission.REPO_READ, "Rescoping pull requests").call((Operation)new UncheckedOperation<RepositoryRescopeResult>(){

                public RepositoryRescopeResult perform() {
                    RepositoryRescopeResult result;
                    int attempt = 1;
                    while ((result = LegacyPullRequestRescopeService.this.attemptUpdatePullRequestsFor(repository, branchesToUsers, attempt)).hasErrors() && attempt++ < 3) {
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("{}: Processed {} rescope requests: {}", new Object[]{repository, requests.size(), requests.stream().map(InternalRescopeRequest.TO_ID).collect(MoreCollectors.toImmutableList())});
                    }
                    return result;
                }
            });
            if (!result.isDone()) {
                branchesToUsers.entrySet().stream().map(entry -> {
                    InternalRescopeRequest.Builder builder = new InternalRescopeRequest.Builder(InternalConverter.convertToInternalRepository((Repository)repository), (InternalApplicationUser)entry.getValue());
                    if (entry.getKey() != null) {
                        builder.changes((Iterable)ImmutableList.of((Object)new MarkerRefChange((String)entry.getKey())));
                    }
                    return builder.build();
                }).forEach(arg_0 -> ((RescopeRequestDao)this.dao).create(arg_0));
            }
            this.dao.deleteByIds((List)requests.stream().map(InternalAbstractEntity::getId).collect(MoreCollectors.toImmutableList()));
            RepositoryRescopeResult repositoryRescopeResult = result;
            return repositoryRescopeResult;
        }
    }

    private RepositoryRescopeResult attemptUpdatePullRequestsFor(Repository repository, Map<String, InternalApplicationUser> branchesToUsers, int attempt) {
        int lockedCount = 0;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PullRequest pullRequest : this.findAffectedPullRequests(repository, branchesToUsers.keySet())) {
            if (pullRequest.isLocked()) {
                ++lockedCount;
                continue;
            }
            builder.add(MINIMIZER.apply((Object)pullRequest));
        }
        ImmutableSet pullRequests = builder.build();
        if (pullRequests.isEmpty()) {
            return new RepositoryRescopeResult(lockedCount, 0);
        }
        SimpleRepositoryRescopeContext context = new SimpleRepositoryRescopeContext((Set<MinimalPullRequest>)pullRequests);
        this.scmService.rescope(new RepositoryRescopeCommandParameters.Builder().repository(repository).rescopeContext((RepositoryRescopeContext)context).build());
        int failureCount = 0;
        ListMultimap<ApplicationUser, MinimalPullRequest> usersToPullRequests = LegacyPullRequestRescopeService.groupByUser((Set<MinimalPullRequest>)pullRequests, branchesToUsers);
        for (ApplicationUser user : usersToPullRequests.keySet()) {
            ImmutableSet userPullRequests = ImmutableSet.copyOf((Collection)usersToPullRequests.get((Object)user));
            Sets.SetView declined = Sets.intersection((Set)context.declined, (Set)userPullRequests);
            Sets.SetView merged = Sets.intersection((Set)context.merged, (Set)userPullRequests);
            Sets.SetView updated = Sets.intersection((Set)context.updated, (Set)userPullRequests);
            failureCount += ((Integer)this.securityService.impersonating(user, "Rescoping pull requests for user").call((Operation)new UncheckedOperation<Integer>((Set)declined, attempt, (Set)merged, (Set)updated){
                final /* synthetic */ Set val$declined;
                final /* synthetic */ int val$attempt;
                final /* synthetic */ Set val$merged;
                final /* synthetic */ Set val$updated;
                {
                    this.val$declined = set;
                    this.val$attempt = n;
                    this.val$merged = set2;
                    this.val$updated = set3;
                }

                public Integer perform() {
                    return LegacyPullRequestRescopeService.applyUpdate(this.val$declined, LegacyPullRequestRescopeService.this.decline, this.val$attempt) + LegacyPullRequestRescopeService.applyUpdate(this.val$merged, LegacyPullRequestRescopeService.this.merge, this.val$attempt) + LegacyPullRequestRescopeService.applyUpdate(this.val$updated, LegacyPullRequestRescopeService.this.rescope, this.val$attempt);
                }
            })).intValue();
        }
        return new RepositoryRescopeResult(lockedCount, failureCount);
    }

    private Iterable<PullRequest> findAffectedPullRequests(Repository repository, Set<String> branchIds) {
        if (branchIds.contains(null)) {
            return this.searchPullRequests(repository, Collections.emptyList());
        }
        Iterable<Object> result = Collections.emptyList();
        for (List partition : Iterables.partition(branchIds, (int)100)) {
            Iterable<PullRequest> pullRequests = this.searchPullRequests(repository, partition);
            result = Iterables.concat(result, pullRequests);
        }
        return result;
    }

    private Map<String, InternalApplicationUser> mapBranchesToUsers(List<InternalRescopeRequest> requests) {
        HashMap<String, InternalApplicationUser> branchToUser = new HashMap<String, InternalApplicationUser>();
        for (InternalRescopeRequest request : requests) {
            if (request.getChanges().isEmpty()) {
                branchToUser.put(null, request.getUser());
                continue;
            }
            for (RefChange change : request.getChanges()) {
                branchToUser.put(change.getRef().getId(), request.getUser());
            }
        }
        return branchToUser;
    }

    private Iterable<PullRequest> searchPullRequests(final Repository repository, final Iterable<String> branchIds) {
        PageRequest initialPageRequest = PageUtils.newRequest((int)0, (int)100);
        return Iterables.concat((Iterable)new PagedIterable((PageProvider)new PageProvider<PullRequest>(){

            public Page<PullRequest> get(PageRequest pageRequest) {
                return LegacyPullRequestRescopeService.this.pullRequestService.search(new PullRequestSearchRequest.Builder().toRefIds(branchIds).toRepositoryId(Integer.valueOf(repository.getId())).state(PullRequestState.OPEN).withProperties(false).build(), pageRequest);
            }
        }, initialPageRequest), (Iterable)new PagedIterable((PageProvider)new PageProvider<PullRequest>(){

            public Page<PullRequest> get(PageRequest pageRequest) {
                return LegacyPullRequestRescopeService.this.pullRequestService.search(new PullRequestSearchRequest.Builder().fromRefIds(branchIds).fromRepositoryId(Integer.valueOf(repository.getId())).state(PullRequestState.OPEN).withProperties(false).build(), pageRequest);
            }
        }, initialPageRequest));
    }

    private static ListMultimap<ApplicationUser, MinimalPullRequest> groupByUser(Set<MinimalPullRequest> pullRequests, final Map<String, InternalApplicationUser> branchesToUsers) {
        return Multimaps.index(pullRequests, (Function)new Function<MinimalPullRequest, ApplicationUser>(){

            public ApplicationUser apply(MinimalPullRequest pullRequest) {
                ApplicationUser user = (ApplicationUser)branchesToUsers.get(pullRequest.getFromRef().getId());
                if (user == null && (user = (ApplicationUser)branchesToUsers.get(pullRequest.getToRef().getId())) == null && (user = (ApplicationUser)branchesToUsers.get(null)) == null) {
                    user = (ApplicationUser)branchesToUsers.values().iterator().next();
                }
                return user;
            }
        });
    }

    private static int applyUpdate(Set<SimpleMinimalPullRequest> pullRequests, RescopeUpdateStrategy strategy, int attempt) {
        int failures = 0;
        for (SimpleMinimalPullRequest pullRequest : pullRequests) {
            try {
                strategy.apply(pullRequest);
            }
            catch (RuntimeException e) {
                ++failures;
                LegacyPullRequestRescopeService.logFailure(String.format(strategy.getErrorFormat(), pullRequest), e, attempt);
            }
        }
        return failures;
    }

    private static void logFailure(String message, Throwable throwable, int attempt) {
        if (attempt < 3) {
            log.debug(message, throwable);
        } else {
            log.warn(message, throwable);
        }
    }

    private static class SimpleMinimalPullRequest
    implements MinimalPullRequest {
        private final PullRequestRef fromRef;
        private final long globalId;
        private final long id;
        private final PullRequestRef toRef;
        private final int version;
        private String newFromHash;
        private String newToHash;

        private SimpleMinimalPullRequest(PullRequest pullRequest) {
            this.fromRef = pullRequest.getFromRef();
            this.globalId = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest).getGlobalId();
            this.id = pullRequest.getId();
            this.toRef = pullRequest.getToRef();
            this.version = pullRequest.getVersion();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof SimpleMinimalPullRequest && this.globalId == ((SimpleMinimalPullRequest)o).globalId;
        }

        @Nonnull
        public PullRequestRef getFromRef() {
            return this.fromRef;
        }

        public long getId() {
            return this.id;
        }

        @Nonnull
        public PullRequestRef getToRef() {
            return this.toRef;
        }

        public int getVersion() {
            return this.version;
        }

        public int hashCode() {
            return Objects.hashCode(this.globalId);
        }

        public String toString() {
            return this.toRef.getRepository().getProject().getKey() + "/" + this.toRef.getRepository().getSlug() + "#" + this.id;
        }
    }

    private static class SimpleRepositoryRescopeContext
    implements RepositoryRescopeContext {
        private final Set<SimpleMinimalPullRequest> declined;
        private final Set<SimpleMinimalPullRequest> merged;
        private final Set<MinimalPullRequest> pullRequests;
        private final Set<SimpleMinimalPullRequest> updated;

        public SimpleRepositoryRescopeContext(Set<MinimalPullRequest> pullRequests) {
            this.pullRequests = pullRequests;
            this.declined = Sets.newHashSet();
            this.merged = Sets.newHashSet();
            this.updated = Sets.newHashSet();
        }

        public void decline(@Nonnull MinimalPullRequest pullRequest) {
            this.declined.add(SimpleRepositoryRescopeContext.checkPullRequest(pullRequest));
        }

        public Iterator<MinimalPullRequest> iterator() {
            return this.pullRequests.iterator();
        }

        public void merge(@Nonnull MinimalPullRequest pullRequest) {
            this.merged.add(SimpleRepositoryRescopeContext.checkPullRequest(pullRequest));
        }

        public void update(@Nonnull MinimalPullRequest pullRequest, @Nonnull String newFromHash, @Nonnull String newToHash) {
            SimpleMinimalPullRequest minimal = SimpleRepositoryRescopeContext.checkPullRequest(pullRequest);
            minimal.newFromHash = newFromHash;
            minimal.newToHash = newToHash;
            this.updated.add(minimal);
        }

        private static SimpleMinimalPullRequest checkPullRequest(MinimalPullRequest pullRequest) {
            Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            Preconditions.checkArgument((boolean)(pullRequest instanceof SimpleMinimalPullRequest), (Object)"The provided MinimalPullRequest does not belong to this RepositoryRescopeContext");
            return (SimpleMinimalPullRequest)pullRequest;
        }
    }

    private static interface RescopeUpdateStrategy {
        public void apply(SimpleMinimalPullRequest var1);

        public String getErrorFormat();
    }

    static class MarkerRefChange
    implements RefChange {
        private final MinimalRef ref;

        public MarkerRefChange(String branchId) {
            this.ref = ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().type((RefType)StandardRefType.BRANCH).id(branchId)).displayId(branchId)).build();
        }

        @Nonnull
        public String getFromHash() {
            return null;
        }

        @Nonnull
        public MinimalRef getRef() {
            return this.ref;
        }

        @Nonnull
        public String getRefId() {
            return this.getRef().getId();
        }

        @Nonnull
        public String getToHash() {
            return null;
        }

        @Nonnull
        public RefChangeType getType() {
            return RefChangeType.UPDATE;
        }
    }
}

