/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.pull.comment.InternalPullRequestCommentHelper;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftRequestDao;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.CompositeCommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.atlassian.stash.internal.pull.comment.drift.InternalDriftRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DriftCommentUpdateProcessor
implements CommentUpdateProcessor {
    static final String FAILURE_CACHE_NAME = CommentUpdateProcessor.class.getName() + ".failedAttempts";
    private static final int MAX_ATTEMPTS = 20;
    private static final Logger log = LoggerFactory.getLogger(DriftCommentUpdateProcessor.class);
    private final CommentDriftRequestDao driftRequestDao;
    private final ExecutorService executorService;
    private final LockService lockService;
    private final Cache failedAttemptsCache;
    private final ScmService scmService;
    private final SecurityService securityService;
    private final CommentDriftStrategy strategy;
    private final TransactionTemplate transactionTemplate;
    @Autowired
    private InternalPullRequestCommentHelper commentHelper;

    public DriftCommentUpdateProcessor(CacheManager cacheManager, CommentDriftRequestDao driftRequestDao, ExecutorService executorService, LockService lockService, ScmService scmService, SecurityService securityService, List<CommentDriftStrategy> strategies, PlatformTransactionManager transactionManager) {
        this.driftRequestDao = driftRequestDao;
        this.executorService = executorService;
        this.failedAttemptsCache = cacheManager.getCache(FAILURE_CACHE_NAME);
        this.lockService = lockService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.strategy = new CompositeCommentDriftStrategy(strategies);
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.securityService.withPermission(Permission.REPO_WRITE, "Reschedule any pending comment drift").call((Operation)new CommentDriftLoader());
    }

    @Override
    public void maybeProcess(InternalPullRequest pullRequest) {
        new CommentDriftBootstrapper(pullRequest).run();
    }

    @Override
    public void process(InternalPullRequest pullRequest, String previousFromHash, String previousToHash) {
        final InternalDriftRequest request = new InternalDriftRequest(null, pullRequest, previousFromHash, previousToHash, pullRequest.getFromRef().getLatestCommit(), pullRequest.getToRef().getLatestCommit());
        try {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalDriftRequest>(){

                public InternalDriftRequest doInTransaction(TransactionStatus status) {
                    return DriftCommentUpdateProcessor.this.driftRequestDao.create(request);
                }
            });
            this.executorService.submit(new CommentDriftBootstrapper(request.getPullRequest()));
        }
        catch (Exception e) {
            log.error("{}:{}@{}: Problem persisting drift request", new Object[]{pullRequest.getScopeRepository().getId(), pullRequest.getId(), pullRequest.getVersion(), e});
        }
    }

    private List<InternalDriftRequest> getPendingDrifts(final InternalPullRequest pullRequest) {
        return (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<InternalDriftRequest>>(){

            public List<InternalDriftRequest> doInTransaction(TransactionStatus status) {
                return DriftCommentUpdateProcessor.this.driftRequestDao.findByGlobalId(pullRequest.getGlobalId());
            }
        });
    }

    private class CommentDriftOperation
    implements UncheckedOperation<Void> {
        private final InternalPullRequest cachedPullRequest;

        private CommentDriftOperation(InternalPullRequest cachedPullRequest) {
            this.cachedPullRequest = cachedPullRequest;
        }

        public Void perform() {
            final List drifts = DriftCommentUpdateProcessor.this.getPendingDrifts(this.cachedPullRequest);
            if (drifts.isEmpty()) {
                log.debug("{}:{}@{}: No rescopes are pending drift", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion()});
                return null;
            }
            final CommentDriftCalculator calculator = this.calculatorFor(drifts);
            try {
                DriftCommentUpdateProcessor.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                    public Void doInTransaction(TransactionStatus status) {
                        try (Timer ignored = TimerUtils.start((String)("Drift: Calculate for " + calculator));){
                            calculator.calculate(drifts);
                            DriftCommentUpdateProcessor.this.driftRequestDao.deleteAll(drifts);
                        }
                        return null;
                    }
                });
            }
            catch (RuntimeException e) {
                int failedAttempts;
                Cache.ValueWrapper failedAttemptsRef = DriftCommentUpdateProcessor.this.failedAttemptsCache.get((Object)this.cachedPullRequest.getGlobalId());
                int n = failedAttempts = failedAttemptsRef == null ? 0 : (Integer)failedAttemptsRef.get();
                if (++failedAttempts <= 20 && this.isRecoverable(e)) {
                    DriftCommentUpdateProcessor.this.failedAttemptsCache.put((Object)this.cachedPullRequest.getGlobalId(), (Object)failedAttempts);
                    log.info("{}:{}@{}: Failed to drift comments (Attempt {} of {}). Rescheduling", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), failedAttempts, 20, e});
                    DriftCommentUpdateProcessor.this.executorService.submit(new CommentDriftBootstrapper(this.cachedPullRequest));
                }
                DriftCommentUpdateProcessor.this.failedAttemptsCache.evict((Object)this.cachedPullRequest.getGlobalId());
                InternalDriftRequest first = (InternalDriftRequest)drifts.get(0);
                InternalDriftRequest last = (InternalDriftRequest)drifts.get(drifts.size() - 1);
                log.error("{}:{}@{}: Error calculating comment drift ({} attempts).\n\tFirst: {}\n\tLast: {}", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), failedAttempts, first, last, e});
            }
            return null;
        }

        private CommentDriftCalculator calculatorFor(List<InternalDriftRequest> drifts) {
            if (drifts.size() > 1) {
                log.debug("{}:{}@{}: Calculating combined drift for {} rescopes", new Object[]{this.cachedPullRequest.getScopeRepository().getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), drifts.size()});
            }
            InternalDriftRequest first = drifts.get(0);
            return new CommentDriftCalculator(this.cachedPullRequest, first.getOldFromHash(), first.getOldToHash());
        }

        private boolean isRecoverable(Exception e) {
            return DataAccessException.class.isAssignableFrom(e.getClass()) || TransactionException.class.isAssignableFrom(e.getClass()) || HibernateException.class.isAssignableFrom(e.getClass());
        }
    }

    private class CommentDriftLoader
    extends TransactionCallbackWithoutResult
    implements UncheckedOperation<Void> {
        private CommentDriftLoader() {
        }

        protected void doInTransactionWithoutResult(TransactionStatus status) {
            List pullRequests = DriftCommentUpdateProcessor.this.driftRequestDao.findPendingPullRequests();
            for (InternalPullRequest pullRequest : pullRequests) {
                DriftCommentUpdateProcessor.this.executorService.submit(new CommentDriftBootstrapper(pullRequest));
            }
        }

        public Void perform() {
            DriftCommentUpdateProcessor.this.transactionTemplate.execute((TransactionCallback)this);
            return null;
        }
    }

    private class CommentDriftCalculator {
        private final InternalPullRequest cachedPullRequest;
        private final String previousFromHash;
        private final String previousToHash;
        private final InternalRepository repository;

        public CommentDriftCalculator(InternalPullRequest cachedPullRequest, String previousFromHash, String previousToHash) {
            this.cachedPullRequest = cachedPullRequest;
            this.previousFromHash = previousFromHash;
            this.previousToHash = previousToHash;
            this.repository = cachedPullRequest.getScopeRepository();
        }

        public void calculate(List<InternalDriftRequest> driftRequests) {
            Map<PullRequestEffectiveDiff, List<InternalPullRequestDiffCommentAnchor>> previousDiffs;
            PullRequestEffectiveDiff effectiveDiff;
            Timer ignored = TimerUtils.start((String)("Drift: Map anchors " + this.cachedPullRequest.getGlobalId()));
            Object object = null;
            try {
                List anchors = DriftCommentUpdateProcessor.this.commentHelper.findDiffAnchors(this.cachedPullRequest);
                if (anchors.isEmpty()) {
                    log.debug("{}:{}@{}: No active diff comments", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion()});
                    return;
                }
                effectiveDiff = (PullRequestEffectiveDiff)DriftCommentUpdateProcessor.this.scmService.getPullRequestCommandFactory((PullRequest)this.cachedPullRequest).effectiveDiff().call();
                previousDiffs = this.mapPreviousDiffs(anchors, effectiveDiff);
            }
            catch (Throwable anchors) {
                object = anchors;
                throw anchors;
            }
            finally {
                if (ignored != null) {
                    if (object != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            if (previousDiffs.isEmpty()) {
                StringBuilder builder = new StringBuilder().append(this.repository.getId()).append(":").append(this.cachedPullRequest.getId()).append("@").append(this.cachedPullRequest.getVersion()).append(": Comments have already been drifted (").append(effectiveDiff.getSinceId()).append(", ").append(effectiveDiff.getUntilId()).append(") when processing ").append(driftRequests.size()).append(" drift request(s):");
                for (InternalDriftRequest driftRequest : driftRequests) {
                    builder.append("\n\t").append(driftRequest);
                }
                log.info(builder.toString());
                return;
            }
            if (previousDiffs.size() > 1) {
                log.warn("{}:{}@{}: Non-orphaned comments span {} diffs", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), previousDiffs.size()});
            }
            for (Map.Entry<PullRequestEffectiveDiff, List<InternalPullRequestDiffCommentAnchor>> entry : previousDiffs.entrySet()) {
                PullRequestEffectiveDiff previousDiff = entry.getKey();
                DriftContext context = new DriftContext(this.repository, this.cachedPullRequest, this.previousFromHash, this.previousToHash, effectiveDiff, previousDiff, entry.getValue());
                try (Timer ignored2 = TimerUtils.start((String)("Drift: Strategy - " + DriftCommentUpdateProcessor.this.strategy.getName() + " " + this.cachedPullRequest.getGlobalId()));){
                    DriftCommentUpdateProcessor.this.strategy.apply(context);
                }
                List<InternalPullRequestDiffCommentAnchor> driftedAnchors = context.done();
                try (Timer ignored3 = TimerUtils.start((String)("Drift: Update anchors " + this.cachedPullRequest.getGlobalId()));){
                    DriftCommentUpdateProcessor.this.commentHelper.updateAnchors(driftedAnchors);
                }
                log.debug("{}:{}@{}: Successfully drifted {} anchors from ({}, {}) to ({}, {})", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), driftedAnchors.size(), previousDiff.getSinceId(), previousDiff.getUntilId(), effectiveDiff.getSinceId(), effectiveDiff.getUntilId()});
            }
        }

        private Map<PullRequestEffectiveDiff, List<InternalPullRequestDiffCommentAnchor>> mapPreviousDiffs(List<DiffCommentAnchor> anchors, PullRequestEffectiveDiff currentDiff) {
            HashMap previousDiffs = Maps.newHashMap();
            for (DiffCommentAnchor anchor : anchors) {
                PullRequestEffectiveDiff diff = new PullRequestEffectiveDiff(anchor.getToHash(), anchor.getFromHash());
                if (currentDiff.equals((Object)diff)) {
                    log.info("{}:{}@{}: Comment {} is already in the current diff ({}, {}) and will not be drifted", new Object[]{this.repository.getId(), this.cachedPullRequest.getId(), this.cachedPullRequest.getVersion(), anchor.getComment().getId(), currentDiff.getSinceId(), currentDiff.getUntilId()});
                    continue;
                }
                List diffAnchors = (List)previousDiffs.get(diff);
                if (diffAnchors == null) {
                    diffAnchors = Lists.newArrayList();
                    previousDiffs.put(diff, diffAnchors);
                }
                diffAnchors.add((InternalPullRequestDiffCommentAnchor)anchor);
            }
            return previousDiffs;
        }
    }

    private class CommentDriftBootstrapper
    implements Runnable,
    UncheckedOperation<Void> {
        private final InternalPullRequest cachedPullRequest;

        private CommentDriftBootstrapper(InternalPullRequest cachedPullRequest) {
            this.cachedPullRequest = cachedPullRequest;
        }

        public Void perform() {
            return (Void)DriftCommentUpdateProcessor.this.lockService.getPullRequestLock(CommentUpdateProcessor.class.getName()).withLock((PullRequest)this.cachedPullRequest, (Operation)new CommentDriftOperation(this.cachedPullRequest));
        }

        @Override
        public void run() {
            DriftCommentUpdateProcessor.this.securityService.withPermission(Permission.REPO_READ, "Performing comment drift").call((Operation)this);
        }
    }
}

